/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.matches;

import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.Protein;
import com.compomics.util.experiment.identification.IdentificationMatch;
import com.compomics.util.experiment.identification.SequenceFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ProteinMatch
extends IdentificationMatch {
    static final long serialVersionUID = -6061842447053092696L;
    private ArrayList<String> theoreticProtein = new ArrayList();
    private String mainMatch;
    private ArrayList<String> peptideMatches = new ArrayList();
    public static final String PROTEIN_KEY_SPLITTER = "_cus_";
    public static final double maxX = 0.25;

    public ProteinMatch() {
    }

    public ProteinMatch(String proteinAccession) throws IllegalArgumentException {
        if (proteinAccession.contains(PROTEIN_KEY_SPLITTER)) {
            throw new IllegalArgumentException("Protein accession containing '_cus_' are not supported. Conflicting accession: " + this.mainMatch);
        }
        this.theoreticProtein.add(proteinAccession);
        this.mainMatch = proteinAccession;
    }

    public ProteinMatch(Peptide peptide, String peptideMatchKey) throws IOException, SQLException, ClassNotFoundException, InterruptedException {
        ArrayList<String> parentProteins = peptide.getParentProteinsNoRemapping();
        if (parentProteins == null || parentProteins.isEmpty()) {
            throw new IllegalArgumentException("Peptide " + peptide.getSequence() + " presents no parent protein.");
        }
        Collections.sort(parentProteins);
        for (String protein : parentProteins) {
            if (this.theoreticProtein.contains(protein)) continue;
            this.theoreticProtein.add(protein);
        }
        this.mainMatch = parentProteins.get(0);
        this.peptideMatches.add(peptideMatchKey);
    }

    public ArrayList<String> getTheoreticProteinsAccessions() {
        return this.theoreticProtein;
    }

    public void addTheoreticProtein(String proteinAccession) {
        this.theoreticProtein.add(proteinAccession);
    }

    public String getMainMatch() {
        return this.mainMatch;
    }

    public void setMainMatch(String mainMatch) {
        this.mainMatch = mainMatch;
    }

    public ArrayList<String> getPeptideMatches() {
        return this.peptideMatches;
    }

    public void addPeptideMatch(String peptideMatchKey) {
        if (!this.peptideMatches.contains(peptideMatchKey)) {
            this.peptideMatches.add(peptideMatchKey);
        }
    }

    public int getPeptideCount() {
        return this.peptideMatches.size();
    }

    public boolean isDecoy() {
        for (String accession : this.theoreticProtein) {
            if (!SequenceFactory.getInstance().isDecoyAccession(accession)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDecoy(String key) {
        SequenceFactory sequenceFactory = SequenceFactory.getInstance();
        for (String accession : ProteinMatch.getAccessions(key)) {
            if (!sequenceFactory.isDecoyAccession(accession)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getKey() {
        Collections.sort(this.theoreticProtein);
        String result = "";
        for (String accession : this.theoreticProtein) {
            if (!result.equals("")) {
                result = result + PROTEIN_KEY_SPLITTER;
            }
            result = result + accession;
        }
        return result;
    }

    public static String getProteinMatchKey(Peptide peptide) throws IOException, SQLException, ClassNotFoundException, InterruptedException {
        ArrayList<String> accessions = new ArrayList<String>();
        ArrayList<String> originalAccessions = peptide.getParentProteinsNoRemapping();
        if (originalAccessions == null) {
            throw new IllegalArgumentException("Proteins not set for peptide " + peptide.getKey() + ".");
        }
        for (String protein : originalAccessions) {
            if (accessions.contains(protein)) continue;
            accessions.add(protein);
        }
        Collections.sort(accessions);
        String result = "";
        for (String accession : accessions) {
            if (!result.equals("")) {
                result = result + PROTEIN_KEY_SPLITTER;
            }
            result = result + accession;
        }
        return result.trim();
    }

    public static int getNProteins(String matchKey) {
        return ProteinMatch.getAccessions(matchKey).length;
    }

    public int getNProteins() {
        return this.theoreticProtein.size();
    }

    public static boolean contains(String sharedKey, String uniqueKey) {
        if (sharedKey.equals(uniqueKey)) {
            return false;
        }
        List<String> sharedAccessions = Arrays.asList(ProteinMatch.getAccessions(sharedKey));
        for (String uniqueAccession : ProteinMatch.getAccessions(uniqueKey)) {
            if (sharedAccessions.contains(uniqueAccession)) continue;
            return false;
        }
        return true;
    }

    public static ArrayList<String> getOtherProteins(String group1, String group2) {
        String[] group1Proteins = ProteinMatch.getAccessions(group1);
        List<String> group2Proteins = Arrays.asList(ProteinMatch.getAccessions(group2));
        ArrayList<String> result = new ArrayList<String>();
        for (String sharedAccession : group1Proteins) {
            if (group2Proteins.contains(sharedAccession)) continue;
            result.add(sharedAccession);
        }
        return result;
    }

    public static ArrayList<String> getCommonProteins(String group1, String group2) {
        String[] group1Proteins = ProteinMatch.getAccessions(group1);
        List<String> group2Proteins = Arrays.asList(ProteinMatch.getAccessions(group2));
        ArrayList<String> result = new ArrayList<String>();
        for (String sharedAccession : group1Proteins) {
            if (!group2Proteins.contains(sharedAccession)) continue;
            result.add(sharedAccession);
        }
        return result;
    }

    public boolean contains(ProteinMatch proteinMatch) {
        if (this.getKey().equals(proteinMatch.getKey())) {
            return false;
        }
        for (String accession : proteinMatch.getTheoreticProteinsAccessions()) {
            if (this.theoreticProtein.contains(accession)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(String aProtein) {
        return this.theoreticProtein.contains(aProtein);
    }

    public static String[] getAccessions(String key) {
        return key.split(PROTEIN_KEY_SPLITTER);
    }

    public boolean hasEnzymaticPeptide(String accession, Enzyme enzyme, AminoAcidPattern.MatchingType matchingType, Double massTolerance) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        SequenceFactory sequenceFactory = SequenceFactory.getInstance();
        for (String peptideKey : this.peptideMatches) {
            String peptideSequence = Peptide.getSequence(peptideKey);
            Protein protein = sequenceFactory.getProtein(accession);
            if (!protein.isEnzymaticPeptide(peptideSequence, enzyme, matchingType, massTolerance)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IdentificationMatch.MatchType getType() {
        return IdentificationMatch.MatchType.Protein;
    }
}

