/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util;

import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import java.awt.Color;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;

public class Util {
    public static final String[] forbiddenCharacters = new String[]{"!", ":", ";", "\\?", "/", "\\\\", "\\*", "<", ">", "\"", "\\|"};
    public static final String separator = "_cus_";

    public static String removeForbiddenCharacters(String string) {
        String result = string;
        for (String fc : forbiddenCharacters) {
            String[] split = string.split(fc);
            result = "";
            for (String splitPart : split) {
                result = result + splitPart;
            }
        }
        return result;
    }

    public static boolean containsForbiddenCharacter(String string) {
        for (String forbiddenCharacter : forbiddenCharacters) {
            if (!string.contains(forbiddenCharacter)) continue;
            return true;
        }
        return false;
    }

    public static double roundDouble(double d, int places) {
        return (double)Math.round(d * Math.pow(10.0, places)) / Math.pow(10.0, places);
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            for (File child : dir.listFiles()) {
                boolean success = Util.deleteDir(child);
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static double getPpmError(double theoreticalMzValue, double massError) {
        double ppmValue = massError / theoreticalMzValue * 1000000.0;
        return ppmValue;
    }

    public static String color2Hex(Color color) {
        return Integer.toHexString(color.getRGB() & 0xFFFFFF);
    }

    public static String getFileName(String filePath) {
        int slash2;
        String tempFileName = filePath;
        int slash1 = tempFileName.lastIndexOf("/");
        int lastSlashIndex = Math.max(slash1, slash2 = tempFileName.lastIndexOf("\\"));
        if (lastSlashIndex != -1) {
            tempFileName = tempFileName.substring(lastSlashIndex + 1);
        }
        return tempFileName;
    }

    public static String getFileName(File file) {
        return Util.getFileName(file.getAbsolutePath());
    }

    public static String getExtension(File file) {
        String fileName = Util.getFileName(file.getAbsolutePath());
        return fileName.substring(fileName.lastIndexOf("."));
    }

    public static String appendSuffix(String fileName, String suffix) {
        String tempName = fileName.substring(0, fileName.lastIndexOf("."));
        String extension = fileName.substring(fileName.lastIndexOf("."));
        return tempName + suffix + extension;
    }

    public static String removeExtension(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public static File getUserSelectedFile(Component parent, String aFileEnding, String aFileFormatDescription, String aDialogTitle, String lastSelectedFolder, boolean openDialog) {
        final String fileEnding = aFileEnding;
        final String fileFormatDescription = aFileFormatDescription;
        JFileChooser fileChooser = new JFileChooser(lastSelectedFolder);
        fileChooser.setDialogTitle(aDialogTitle);
        fileChooser.setMultiSelectionEnabled(false);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.getName().toLowerCase().endsWith(fileEnding) || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return fileFormatDescription;
            }
        };
        fileChooser.setFileFilter(filter);
        int returnVal = openDialog ? fileChooser.showOpenDialog(parent) : fileChooser.showSaveDialog(parent);
        if (returnVal == 0) {
            String selectedFile = fileChooser.getSelectedFile().getPath();
            if (!selectedFile.endsWith(fileEnding)) {
                selectedFile = selectedFile + fileEnding;
            }
            File newFile = new File(selectedFile);
            int outcome = 0;
            if (!openDialog && newFile.exists()) {
                outcome = JOptionPane.showConfirmDialog(parent, "Should " + selectedFile + " be overwritten?", "Selected File Already Exists", 0, 2);
            } else if (openDialog && !newFile.exists()) {
                JOptionPane.showMessageDialog(parent, "The file'" + newFile.getAbsolutePath() + "' " + "does not exist!", "File Not Found.", 0);
                return null;
            }
            if (outcome != 0) {
                return null;
            }
            return newFile;
        }
        return null;
    }

    public static File getUserSelectedFolder(Component parent, String aDialogTitle, String lastSelectedFolder, String aFolderDescription, String approveButtonText, boolean openDialog) {
        JFileChooser fileChooser = new JFileChooser(lastSelectedFolder);
        final String folderDescription = aFolderDescription;
        fileChooser.setDialogTitle(aDialogTitle);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(1);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return folderDescription;
            }
        };
        fileChooser.setFileFilter(filter);
        int returnVal = fileChooser.showDialog(parent, approveButtonText);
        if (returnVal == 0) {
            File selectedFolder = fileChooser.getSelectedFile();
            if (!selectedFolder.exists()) {
                if (openDialog) {
                    JOptionPane.showMessageDialog(parent, "The folder '" + selectedFolder.getAbsolutePath() + "' does not exist.\n" + "Please choose an existing folder.", "Folder Error", 0);
                    return null;
                }
                int value = JOptionPane.showConfirmDialog(parent, "The folder '" + selectedFolder.getAbsolutePath() + "' does not exist.\n" + "Do you want to create it?", "Create Folder?", 0);
                if (value == 1) {
                    return null;
                }
                boolean success = selectedFolder.mkdir();
                if (!success) {
                    JOptionPane.showMessageDialog(parent, "Failed to create the folder. Please create it manually and then select it.", "File Error", 1);
                    return null;
                }
            }
            return selectedFolder;
        }
        return null;
    }

    public static String tableToText(JTable table, String separator, ProgressDialogX progressDialog, boolean removeHtml) {
        int i;
        StringBuilder tableAsString = new StringBuilder();
        for (i = 0; i < table.getColumnCount() && !progressDialog.isRunCanceled(); ++i) {
            tableAsString.append(table.getColumnName(i)).append(separator);
        }
        progressDialog.setPrimaryProgressCounterIndeterminate(false);
        progressDialog.setMaxPrimaryProgressCounter(table.getRowCount());
        tableAsString.append(System.getProperty("line.separator"));
        for (i = 0; i < table.getRowCount() && !progressDialog.isRunCanceled(); ++i) {
            progressDialog.increasePrimaryProgressCounter();
            for (int j = 0; j < table.getColumnCount() && !progressDialog.isRunCanceled(); ++j) {
                if (table.getValueAt(i, j) != null) {
                    String tempValue = table.getValueAt(i, j).toString();
                    if (tempValue.indexOf("<html>") != -1 && removeHtml) {
                        tempValue = tempValue.replaceAll("\\<[^>]*>", "");
                    }
                    tableAsString.append(tempValue).append(separator);
                    continue;
                }
                tableAsString.append(separator);
            }
            tableAsString.append(System.getProperty("line.separator"));
        }
        return tableAsString.toString();
    }

    public static void tableToFile(JTable table, String separator, ProgressDialogX progressDialog, boolean removeHtml, BufferedWriter writer) throws IOException {
        int i;
        for (i = 0; i < table.getColumnCount(); ++i) {
            writer.write(table.getColumnName(i) + separator);
        }
        if (progressDialog != null) {
            progressDialog.setPrimaryProgressCounterIndeterminate(false);
            progressDialog.setMaxPrimaryProgressCounter(table.getRowCount());
        }
        writer.write(System.getProperty("line.separator"));
        for (i = 0; i < table.getRowCount(); ++i) {
            if (progressDialog != null) {
                if (progressDialog.isRunCanceled()) {
                    return;
                }
                progressDialog.increasePrimaryProgressCounter();
            }
            for (int j = 0; j < table.getColumnCount(); ++j) {
                if (progressDialog != null && progressDialog.isRunCanceled()) {
                    return;
                }
                if (table.getValueAt(i, j) != null) {
                    String tempValue = table.getValueAt(i, j).toString();
                    if (tempValue.indexOf("<html>") != -1 && removeHtml) {
                        tempValue = tempValue.replaceAll("\\<[^>]*>", "");
                    }
                    writer.write(tempValue + separator);
                    continue;
                }
                writer.write(separator);
            }
            writer.write(System.getProperty("line.separator"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File in, File out) throws IOException {
        FileChannel inChannel = new FileInputStream(in).getChannel();
        FileChannel outChannel = new FileOutputStream(out).getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumberOfLines(File file) throws IOException {
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            int readChars;
            byte[] c = new byte[1024];
            int lineCount = 0;
            while ((readChars = ((InputStream)inputStream).read(c)) != -1) {
                for (int i = 0; i < readChars; ++i) {
                    if (c[i] != 10) continue;
                    ++lineCount;
                }
            }
            int n = lineCount;
            return n;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    public static boolean sameLists(ArrayList list1, ArrayList list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        ArrayList list1copy = new ArrayList(list1);
        Collections.sort(list1copy);
        ArrayList list2copy = new ArrayList(list2);
        Collections.sort(list2copy);
        for (int i = 0; i < list1copy.size(); ++i) {
            if (list1copy.get(i).equals(list2copy.get(i))) continue;
            return false;
        }
        return true;
    }

    public static int getOccurrence(String input, char character) {
        int result = 0;
        for (char aa : input.toCharArray()) {
            if (aa != character) continue;
            ++result;
        }
        return result;
    }

    public static ArrayList<Integer> getIndexes(String bigString, String smallString) {
        Pattern pattern = Pattern.compile(smallString);
        ArrayList<Integer> result = new ArrayList<Integer>();
        Matcher matcher = pattern.matcher(bigString);
        matcher.matches();
        int index = 0;
        while (matcher.find(index)) {
            index = matcher.start();
            result.add(++index);
        }
        return result;
    }
}

