/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.util.mascot.fragmentions;

import com.compomics.mascotdatfile.util.exception.MascotDatfileException;
import com.compomics.mascotdatfile.util.interfaces.FragmentIon;
import com.compomics.mascotdatfile.util.mascot.Peak;
import java.awt.Color;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class FragmentIonImpl
implements FragmentIon,
Cloneable,
Serializable {
    private static Logger logger = Logger.getLogger(FragmentIonImpl.class);
    private double iMZ = 0.0;
    private double iIntensity = 0.0;
    private int iNumber = 0;
    private int iID = 0;
    private String iType = null;
    private double iTheoreticalExperimantalMassError = 0.0;
    private Color iColor = null;
    private int iImportance = 0;
    private double iErrorMargin = 0.0;
    private boolean boolMatch = false;

    public FragmentIonImpl(double aMZ, double aErrorMargin, int aID, int aNumber, String aType) {
        this.iMZ = aMZ;
        this.iErrorMargin = aErrorMargin;
        this.iID = aID;
        this.iNumber = aNumber;
        this.iType = aType;
        this.setDefaultColor();
    }

    public FragmentIonImpl(double aMZ, double aIntensity, double aErrorMargin, int aID, int aNumber, String aType) {
        this(aMZ, aErrorMargin, aID, aNumber, aType);
        this.iIntensity = aIntensity;
    }

    public FragmentIonImpl(double aMZ, double aIntensity, double aErrorMargin, int aID, int aNumber, String aType, Color aColor) {
        this(aMZ, aErrorMargin, aID, aNumber, aType);
        this.iIntensity = aIntensity;
        this.iColor = aColor;
    }

    public FragmentIonImpl(double aMZ, double aErrorMargin, int aID, int aNumber, String aType, Color aColor) {
        this(aMZ, aErrorMargin, aID, aNumber, aType);
        this.iColor = aColor;
    }

    public double getMZ() {
        return this.iMZ;
    }

    public void setMZ(double aMZ) {
        this.iMZ = aMZ;
    }

    public double getIntensity() {
        return this.iIntensity;
    }

    public int getNumber() {
        return this.iNumber;
    }

    public int getID() {
        return this.iID;
    }

    public String getType() {
        return this.iType;
    }

    public void setType(String aType) {
        this.iType = aType;
    }

    public Color getColor() {
        return this.iColor;
    }

    public void setColor(Color aColor) {
        this.iColor = aColor;
    }

    public int getImportance() {
        return this.iImportance;
    }

    public void setImportance(int aImportance) {
        this.iImportance = aImportance;
    }

    public double getErrorMargin() {
        return this.iErrorMargin;
    }

    public String getLabel() {
        StringBuffer label = new StringBuffer();
        if (this.iID < 31) {
            if (this.iImportance == 0) {
                label.append('&');
            } else if (this.iImportance == 1) {
                label.append('#');
            }
            if (this.getType().length() > 1) {
                label.append(this.getType().substring(0, 1) + "[" + this.getNumber() + "]" + this.getType().substring(1));
            } else {
                label.append(this.getType() + this.getNumber());
            }
        } else {
            label.append(this.iType);
        }
        return label.toString();
    }

    public double getTheoreticalExperimantalMassError() {
        return this.iTheoreticalExperimantalMassError;
    }

    public boolean isMatch(Peak[] aPeaks, double aErrorMargin) {
        if (!this.boolMatch) {
            for (int i = 0; i < aPeaks.length; ++i) {
                if (!(-aErrorMargin <= aPeaks[i].getMZ() - this.iMZ) || !(aPeaks[i].getMZ() - this.iMZ <= aErrorMargin)) continue;
                this.iTheoreticalExperimantalMassError = aPeaks[i].getMZ() - this.iMZ;
                this.boolMatch = true;
                this.iIntensity = aPeaks[i].getIntensity();
                break;
            }
        }
        return this.boolMatch;
    }

    public boolean isMatchAboveIntensityThreshold(Peak[] aPeaks, double aMaxIntensity, double aIntensityPercentage, double aErrorMargin) {
        if (!this.boolMatch) {
            double lIntensityThreshold = aMaxIntensity * aIntensityPercentage;
            for (int i = 0; i < aPeaks.length; ++i) {
                if (!(aPeaks[i].getIntensity() > lIntensityThreshold) || !(-aErrorMargin < aPeaks[i].getMZ() - this.iMZ) || !(aPeaks[i].getMZ() - this.iMZ < aErrorMargin)) continue;
                this.iTheoreticalExperimantalMassError = aPeaks[i].getMZ() - this.iMZ;
                this.boolMatch = true;
                this.iIntensity = aPeaks[i].getIntensity();
                break;
            }
        }
        return this.boolMatch;
    }

    public boolean isDoubleCharged() {
        boolean bl = false;
        if (this.iType.indexOf(43) != -1) {
            bl = true;
        }
        return bl;
    }

    public boolean hasBeenMatched() {
        return this.boolMatch;
    }

    public void setDefaultColor() {
        try {
            switch (this.iID) {
                case 13: {
                    this.iColor = new Color(153, 0, 0);
                    break;
                }
                case 14: {
                    this.iColor = new Color(0, 139, 0);
                    break;
                }
                case 15: {
                    this.iColor = new Color(171, 161, 255);
                    break;
                }
                case 16: {
                    this.iColor = new Color(171, 161, 255);
                    break;
                }
                case 17: {
                    this.iColor = new Color(248, 151, 202);
                    break;
                }
                case 18: {
                    this.iColor = new Color(248, 151, 202);
                    break;
                }
                case 1: {
                    this.iColor = new Color(0, 0, 255);
                    break;
                }
                case 2: {
                    this.iColor = new Color(0, 0, 255);
                    break;
                }
                case 3: {
                    this.iColor = new Color(0, 125, 200);
                    break;
                }
                case 4: {
                    this.iColor = new Color(0, 125, 200);
                    break;
                }
                case 5: {
                    this.iColor = new Color(153, 0, 255);
                    break;
                }
                case 6: {
                    this.iColor = new Color(153, 0, 255);
                    break;
                }
                case 21: {
                    this.iColor = new Color(188, 0, 255);
                    break;
                }
                case 22: {
                    this.iColor = new Color(188, 0, 255);
                    break;
                }
                case 19: {
                    this.iColor = new Color(78, 200, 0);
                    break;
                }
                case 20: {
                    this.iColor = new Color(78, 200, 0);
                    break;
                }
                case 7: {
                    this.iColor = new Color(0, 0, 0);
                    break;
                }
                case 8: {
                    this.iColor = new Color(0, 0, 0);
                    break;
                }
                case 9: {
                    this.iColor = new Color(0, 70, 135);
                    break;
                }
                case 10: {
                    this.iColor = new Color(0, 70, 135);
                    break;
                }
                case 11: {
                    this.iColor = new Color(155, 0, 155);
                    break;
                }
                case 12: {
                    this.iColor = new Color(155, 0, 155);
                    break;
                }
                case 23: {
                    this.iColor = new Color(255, 140, 0);
                    break;
                }
                case 24: {
                    this.iColor = new Color(64, 179, 0);
                    break;
                }
                case 25: {
                    this.iColor = new Color(255, 140, 0);
                    break;
                }
                case 26: {
                    this.iColor = new Color(64, 179, 0);
                    break;
                }
                case 27: {
                    this.iColor = new Color(255, 140, 0);
                    break;
                }
                case 28: {
                    this.iColor = new Color(64, 179, 0);
                    break;
                }
                case 31: {
                    this.iColor = Color.red;
                    break;
                }
                case 30: {
                    this.iColor = Color.red;
                    break;
                }
                case 32: {
                    this.iColor = Color.gray;
                    break;
                }
                default: {
                    throw new MascotDatfileException("No correct Color could be chosen in the creation of the FragmentIonImpl instance.\nThis means that there was no correct assignement of the fragmention type!");
                }
            }
        }
        catch (MascotDatfileException e) {
            e.printStackTrace();
        }
    }

    public FragmentIonImpl clone() throws CloneNotSupportedException {
        FragmentIonImpl fi = null;
        try {
            fi = (FragmentIonImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return fi;
    }

    public void resetMatchingValues() {
        this.boolMatch = false;
        this.iTheoreticalExperimantalMassError = 0.0;
        this.iIntensity = 0.0;
    }
}

