/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.research.tool.spectrumviewer.spectrumviewer_model;

import com.compomics.mascotdatfile.util.mascot.PeptideHit;
import java.util.Hashtable;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class PeptideHitTableModel
extends AbstractTableModel {
    private static Logger logger = Logger.getLogger(PeptideHitTableModel.class);
    private Hashtable iRowElements = null;
    private PeptideHit[] iPh;
    private static PeptideHitTableModel iPeptideHitTableModel = null;

    private PeptideHitTableModel(PeptideHit[] aPh) {
        this.iPh = aPh;
        if (this.iRowElements == null) {
            this.iRowElements = new Hashtable();
            this.constructRowElements();
        }
    }

    public static PeptideHitTableModel getPeptideHitTableModel(PeptideHit[] aPh) {
        if (iPeptideHitTableModel == null) {
            iPeptideHitTableModel = new PeptideHitTableModel(aPh);
        }
        return iPeptideHitTableModel;
    }

    public static PeptideHitTableModel getPeptideHitTableModel(PeptideHit aPh) {
        if (iPeptideHitTableModel == null) {
            iPeptideHitTableModel = new PeptideHitTableModel(new PeptideHit[]{aPh});
        }
        return iPeptideHitTableModel;
    }

    public int getRowCount() {
        return this.iRowElements.size();
    }

    public int getColumnCount() {
        return this.iPh.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        String lValue = null;
        if (columnIndex == 0) {
            lValue = this.getRowElementInformation(rowIndex);
        } else if (columnIndex > 0) {
            lValue = this.getPeptideHitInformation(this.iPh[columnIndex - 1], rowIndex);
        }
        return lValue;
    }

    private String getRowElementInformation(int rowIndex) {
        String lValue = null;
        switch (rowIndex) {
            case 0: {
                lValue = (String)this.iRowElements.get(PeptideHit.SEQUENCE);
                break;
            }
            case 1: {
                lValue = (String)this.iRowElements.get(PeptideHit.MODIFIED_SEQUENCE);
                break;
            }
            case 2: {
                lValue = (String)this.iRowElements.get(PeptideHit.IONS_SCORE);
                break;
            }
            case 3: {
                lValue = (String)this.iRowElements.get(PeptideHit.THRESHOLD);
                break;
            }
            default: {
                throw new IllegalArgumentException("Number of table rows is bigger then the RowElementInformation supply!!");
            }
        }
        return lValue;
    }

    private String getPeptideHitInformation(PeptideHit aPh, int rowIndex) {
        String lValue = null;
        switch (rowIndex) {
            case 0: {
                lValue = aPh.getSequence();
                break;
            }
            case 1: {
                lValue = aPh.getModifiedSequence();
                break;
            }
            case 2: {
                lValue = Double.toString(aPh.getIonsScore());
                break;
            }
            case 3: {
                lValue = Double.toString(aPh.calculateIdentityThreshold());
                break;
            }
            default: {
                throw new IllegalArgumentException("Number of table rows is bigger then the RowElementInformation supply!!");
            }
        }
        return lValue;
    }

    private void constructRowElements() {
        this.iRowElements.put(PeptideHit.SEQUENCE, "Sequence");
        this.iRowElements.put(PeptideHit.MODIFIED_SEQUENCE, "Modified sequence");
        this.iRowElements.put(PeptideHit.IONS_SCORE, "Score");
        this.iRowElements.put(PeptideHit.THRESHOLD, "Threshold");
    }
}

