/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.multicompare.visitors;

import edu.msu.cme.rdp.multicompare.MCSample;
import edu.msu.cme.rdp.multicompare.taxon.MCTaxon;
import edu.msu.cme.rdp.taxatree.VisitInfo;
import edu.msu.cme.rdp.taxatree.interfaces.TreeVisitor;
import java.io.PrintStream;
import java.util.List;

public class DefaultPrintVisitor
implements TreeVisitor<MCTaxon> {
    private PrintStream out;
    private List<MCSample> samples;
    private boolean ommitEmpty;

    public DefaultPrintVisitor(PrintStream out, List<MCSample> samples) {
        this(out, samples, true);
    }

    public DefaultPrintVisitor(PrintStream out, List<MCSample> samples, boolean ommitEmpty) {
        this.out = out;
        this.samples = samples;
        this.printHeader();
    }

    private void printHeader() {
        String ret = "taxid\tlineage\tname\trank";
        for (MCSample sample : this.samples) {
            ret = ret + "\t" + sample.getSampleName();
        }
        this.out.println(ret);
    }

    public boolean visitNode(VisitInfo<MCTaxon> info) {
        StringBuffer sampleBuf = new StringBuffer();
        MCTaxon taxon = (MCTaxon)info.getTaxon();
        int seqCount = 0;
        for (MCSample sample : this.samples) {
            sampleBuf.append("\t" + taxon.getCount(sample));
            seqCount += taxon.getCount(sample);
        }
        if (seqCount > 0 || !this.ommitEmpty) {
            this.out.println(taxon.getTaxid() + "\t" + taxon.getLineage() + "\t" + taxon.getName() + "\t" + taxon.getRank() + sampleBuf);
        }
        return true;
    }
}

