/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.alignment;

import edu.msu.cme.rdp.alignment.AlignNucleotideToProtein;
import edu.msu.cme.rdp.alignment.AlignmentMerger;
import edu.msu.cme.rdp.alignment.PairedReadAssembler;
import edu.msu.cme.rdp.alignment.errorcheck.CompareErrorType;
import edu.msu.cme.rdp.alignment.errorcheck.RmPartialSeqs;
import edu.msu.cme.rdp.alignment.pairwise.PairwiseKNN;
import java.util.Arrays;

public class AlignmentToolsMain {
    private static void printUsageAndExit() {
        System.err.println("USAGE: AlignmentToolsMain <subcommand> <options>");
        System.err.println("\talignment-merger     - Merge alignments");
        System.err.println("\tpairwise-knn         - Compute k-nearest-neighbors by pairwise alignment");
        System.err.println("\tcompare-error-type   - Detect insertion, deletion and substitution errors in sequences comparing to reference sequences");
        System.err.println("\talign-nucl-to-prot   - Transfer a sequence alignment from protein sequences to nucleotide sequences");
        System.err.println("\trm-partialseq        - remove partial sequences based on pairwise alignment to reference sequences");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            AlignmentToolsMain.printUsageAndExit();
        }
        String command = args[0];
        args = Arrays.copyOfRange(args, 1, args.length);
        if (command.equals("alignment-merger")) {
            AlignmentMerger.main(args);
        } else if (command.equals("pairwise-knn")) {
            PairwiseKNN.main(args);
        } else if (command.equals("compare-error-type")) {
            CompareErrorType.main(args);
        } else if (command.equals("paired-end-assembler")) {
            PairedReadAssembler.main(args);
        } else if (command.equals("align-nucl-to-prot")) {
            AlignNucleotideToProtein.main(args);
        } else if (command.equals("rm-partialseq")) {
            RmPartialSeqs.main(args);
        } else {
            AlignmentToolsMain.printUsageAndExit();
            System.err.println("Unknown command: " + command);
        }
    }
}

