/*
 * Decompiled with CFR 0.152.
 */
package eponine;

import com.sun.xml.parser.Resolver;
import com.sun.xml.tree.XmlDocument;
import eponine.datasource.DataSource;
import eponine.model.EponineXML;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.stats.svm.ItemValue;
import org.biojava.stats.svm.SVMTarget;
import org.biojava.utils.xml.AppEntry;
import org.xml.sax.InputSource;
import stats.glm.GLMClassificationModel;

public class FullTestCore
implements AppEntry {
    private DataSource dataSource;
    private String fileName;
    private String taintFile;
    private int clusterTolerance;
    private Map sequences = new HashMap();

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setTaintFile(String string) {
        this.taintFile = string;
    }

    public void setClusterTolerance(int n) {
        this.clusterTolerance = n;
    }

    public void start(String[] stringArray) {
        try {
            int n;
            String string;
            int n2;
            Object object;
            EponineXML eponineXML = new EponineXML();
            InputSource inputSource = Resolver.createInputSource((File)new File(this.fileName));
            XmlDocument xmlDocument = XmlDocument.createXmlDocument((InputSource)inputSource, (boolean)false);
            GLMClassificationModel gLMClassificationModel = eponineXML.xmlToModel(xmlDocument.getDocumentElement());
            double[] dArray = new double[25];
            int n3 = 0;
            while (n3 < dArray.length) {
                dArray[n3] = Math.pow(10.0, -7.0 + (double)n3 * 0.25);
                ++n3;
            }
            int n4 = 0;
            int[] nArray = new int[dArray.length];
            int[] nArray2 = new int[dArray.length];
            int[] nArray3 = new int[dArray.length];
            SVMTarget sVMTarget = this.dataSource.getTestExamples();
            Iterator iterator = sVMTarget.itemTargets().iterator();
            while (iterator.hasNext()) {
                object = (ItemValue)iterator.next();
                double d = object.getValue();
                if (d != 1.0) continue;
                double d2 = gLMClassificationModel.positiveProbability(object.getItem());
                n2 = 0;
                while (n2 < dArray.length) {
                    if (d2 > 1.0 - dArray[n2]) {
                        int n5 = n2;
                        nArray[n5] = nArray[n5] + 1;
                    }
                    ++n2;
                }
                ++n4;
            }
            object = new TreeSet();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.taintFile));
            while ((string = bufferedReader.readLine()) != null) {
                object.add(new Integer(Integer.parseInt(string)));
            }
            bufferedReader.close();
            object.add(new Integer(Integer.MAX_VALUE));
            SymbolList symbolList = this.getSequence("chri", "+");
            int n6 = 0;
            n2 = 0;
            int n7 = 40000;
            while (n7 < 80000) {
                if (n7 % 1000 == 0) {
                    System.out.print('.');
                }
                n = (Integer)object.first();
                while (n7 > n) {
                    object.remove(object.first());
                    n = (Integer)object.first();
                }
                SymbolList symbolList2 = symbolList.subList(n7 - 500, n7);
                double d = 0.0;
                if (n - n7 > 1000) {
                    ++n6;
                    d = gLMClassificationModel.positiveProbability(symbolList2);
                    int n8 = 0;
                    while (n8 < dArray.length) {
                        if (d > 1.0 - dArray[n8]) {
                            if (n7 - nArray3[n8] > this.clusterTolerance) {
                                int n9 = n8;
                                nArray2[n9] = nArray2[n9] + 1;
                            }
                            nArray3[n8] = n7;
                        }
                        ++n8;
                    }
                } else {
                    ++n2;
                }
                ++n7;
            }
            System.out.println("Done!");
            System.out.println("ROC Curve");
            n = 0;
            while (n < dArray.length) {
                System.out.println("" + dArray[n] + " " + 1.0 * (double)n6 / (double)nArray2[n] + " " + (double)nArray[n] * 100.0 / (double)n4);
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private SymbolList getSequence(String string, String string2) throws Exception {
        String string3 = string + " " + string2;
        SymbolList symbolList = (SymbolList)this.sequences.get(string3);
        if (symbolList != null) {
            return symbolList;
        }
        if (string2.equals("-")) {
            SymbolList symbolList2 = this.getSequence(string, "+");
            symbolList = DNATools.reverseComplement(symbolList2);
        } else {
            try {
                String string4 = "/nfs/disk80/td2/rt/data/sacch/" + string + ".fa";
                FastaFormat fastaFormat = new FastaFormat();
                SequenceBuilderFactory sequenceBuilderFactory = SimpleSequenceBuilder.FACTORY;
                StreamReader streamReader = new StreamReader(new FileInputStream(string4), (SequenceFormat)fastaFormat, DNATools.getDNA().getParser("token"), sequenceBuilderFactory);
                symbolList = streamReader.nextSequence();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.sequences.put(string3, symbolList);
        return symbolList;
    }
}

