/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.experiment.metadata;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.systemsbiology.gaggle.experiment.metadata.Condition;
import org.systemsbiology.gaggle.experiment.metadata.MetaData;
import org.systemsbiology.gaggle.experiment.metadata.Variable;
import org.systemsbiology.gaggle.experiment.repository.ExperimentRepository;
import org.systemsbiology.gaggle.experiment.repository.ExperimentRepositoryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataList {
    private URI uri;
    private Map<String, Map<Condition, String>> tagMap = null;
    private MetaData[] listOfAllMetadata = null;
    private Map<String, List<TreePath>> conditionNameToPerturbationStringsHash = new HashMap<String, List<TreePath>>();

    public MetaDataList(String uriString) throws URISyntaxException {
        this.uri = new URI(uriString);
    }

    public MetaData[] getList() throws Exception {
        if (this.listOfAllMetadata != null) {
            return this.listOfAllMetadata;
        }
        ExperimentRepository repos = ExperimentRepositoryFactory.create((String)this.uri.toString());
        ArrayList<MetaData> list = new ArrayList<MetaData>();
        for (String name : repos.getExperimentNames()) {
            list.add(repos.getMetaData(name));
        }
        this.listOfAllMetadata = list.toArray(new MetaData[0]);
        return this.listOfAllMetadata;
    }

    public Map<String, List<TreePath>> getConditionToPerturbationStringHash(JTree tree) throws Exception {
        MetaData[] allMetadata;
        if (this.conditionNameToPerturbationStringsHash.size() > 0) {
            return this.conditionNameToPerturbationStringsHash;
        }
        for (MetaData metadata : allMetadata = this.getList()) {
            for (Condition cond : metadata.getConditions()) {
                ArrayList<TreePath> treePaths = new ArrayList<TreePath>();
                for (String treePathString : metadata.getTreePaths()) {
                    for (Variable var : cond.getVariables()) {
                        String path = treePathString + ":" + var.getName();
                        path = path + ":" + var.getValue();
                        treePaths.add(this.getTreePathFromPerturbationString(path, tree));
                    }
                }
                this.conditionNameToPerturbationStringsHash.put(cond.getAlias(), treePaths);
            }
        }
        return this.conditionNameToPerturbationStringsHash;
    }

    private TreePath getTreePathFromPerturbationString(String perturbationString, JTree tree) {
        String[] pathSegments;
        ArrayList<DefaultMutableTreeNode> pathElements = new ArrayList<DefaultMutableTreeNode>();
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        pathElements.add(root);
        DefaultMutableTreeNode currentTopNode = root;
        block0: for (String pathSegment : pathSegments = perturbationString.split(":")) {
            for (int j = 0; j < currentTopNode.getChildCount(); ++j) {
                DefaultMutableTreeNode candidate = (DefaultMutableTreeNode)currentTopNode.getChildAt(j);
                if (!candidate.toString().equals(pathSegment)) continue;
                pathElements.add(candidate);
                currentTopNode = candidate;
                continue block0;
            }
        }
        return new TreePath(pathElements.toArray(new DefaultMutableTreeNode[0]));
    }

    public TreePath[] getTreePathsForConditionNames(String[] conditionNames, JTree tree) throws Exception {
        Map<String, List<TreePath>> map = this.getConditionToPerturbationStringHash(tree);
        ArrayList<TreePath> treePathList = new ArrayList<TreePath>();
        for (String alias : conditionNames) {
            List<TreePath> results = map.get(alias);
            for (TreePath result : results) {
                if (treePathList.contains(result)) continue;
                treePathList.add(result);
            }
        }
        return treePathList.toArray(new TreePath[0]);
    }

    public String[] getAllTags() throws Exception {
        if (this.tagMap == null) {
            this.buildTagMap();
        }
        String[] result = this.tagMap.keySet().toArray(new String[0]);
        Arrays.sort(result, String.CASE_INSENSITIVE_ORDER);
        return result;
    }

    private void addAllConditionsInExperimentToTagMap(String tag, MetaData metadata) {
        if (this.tagMap.get(tag = tag.toLowerCase()) == null) {
            this.tagMap.put(tag, new HashMap());
        }
        for (Condition cond : metadata.getConditions()) {
            if (tag == null || tag.trim().equals("")) continue;
            this.tagMap.get(tag).put(cond, null);
        }
    }

    private void addConditionToTagMap(String tag, Condition condition) {
        if (this.tagMap.get(tag = tag.toLowerCase()) == null) {
            this.tagMap.put(tag, new HashMap());
        }
        if (tag != null && !tag.trim().equals("")) {
            this.tagMap.get(tag).put(condition, null);
        }
    }

    private void buildTagMap() throws Exception {
        MetaData[] all;
        this.tagMap = new HashMap<String, Map<Condition, String>>();
        for (MetaData metadata : all = this.getList()) {
            for (Condition condition : metadata.getConditions()) {
                for (Variable variable : condition.getVariables()) {
                    this.addConditionToTagMap(variable.getName(), condition);
                    String value = variable.getValue();
                    if (variable.getUnits() != null) {
                        value = value + " " + variable.getUnits();
                    }
                    this.addConditionToTagMap(value, condition);
                }
            }
            for (String predicate : metadata.getPredicateNamesSorted()) {
                if (predicate.toLowerCase().contains("perturbation")) {
                    String[] segments;
                    String path = metadata.getPredicate(predicate);
                    for (String segment : segments = path.split(":")) {
                        this.addAllConditionsInExperimentToTagMap(segment, metadata);
                    }
                    continue;
                }
                this.addAllConditionsInExperimentToTagMap(metadata.getPredicate(predicate), metadata);
            }
        }
    }

    private Map<Condition, String> getWildCardMatches(String tag) {
        if (!(tag = tag.toLowerCase()).endsWith("*")) {
            return this.tagMap.get(tag);
        }
        tag = tag.substring(0, tag.length() - 1);
        HashMap<Condition, String> returnValue = new HashMap<Condition, String>();
        for (String candidate : this.tagMap.keySet()) {
            if (!candidate.startsWith(tag)) continue;
            for (Condition cond : this.tagMap.get(candidate).keySet()) {
                returnValue.put(cond, null);
            }
        }
        return returnValue;
    }

    public Condition[] filterMetaDataByTags(String[] tags) throws Exception {
        if (tags == null || tags.length == 0) {
            return new Condition[0];
        }
        for (int i = 0; i < tags.length; ++i) {
            tags[i] = tags[i].toLowerCase();
        }
        if (this.tagMap == null) {
            this.buildTagMap();
        }
        Map<Condition, String> prevMatches = this.getWildCardMatches(tags[0]);
        assert (prevMatches != null);
        for (int i = 1; i < tags.length; ++i) {
            Map<Condition, String> matches = this.getWildCardMatches(tags[i]);
            if (matches == null) {
                System.out.println("matches was null, tag is " + tags[i]);
                return new Condition[0];
            }
            HashMap<Condition, String> nextMatches = new HashMap<Condition, String>();
            for (Condition cond : matches.keySet()) {
                if (!prevMatches.containsKey(cond)) continue;
                nextMatches.put(cond, null);
            }
            prevMatches = nextMatches;
        }
        try {
            return prevMatches.keySet().toArray(new Condition[0]);
        }
        catch (NullPointerException npe) {
            return new Condition[0];
        }
    }

    public static void main(String[] args) {
        try {
            String repos = "file:///net/arrays/emi/halobacterium/repos";
            MetaDataList mdl = new MetaDataList(repos);
            mdl.buildTagMap();
            Condition[] matches = mdl.filterMetaDataByTags(new String[]{"VNG1179C", "cu"});
            System.out.println("# of matches: " + matches.length);
            for (Condition match : matches) {
                System.out.println(match.getAlias());
            }
            System.out.println("# of matches: " + matches.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

