### R code from vignette source 'fastseg.Rnw'

###################################################
### code chunk number 1: fastseg.Rnw:39-42
###################################################
options(width=80)
set.seed(0)
fastsegVersion <- packageDescription("fastseg")$Version


###################################################
### code chunk number 2: fastseg.Rnw:106-107
###################################################
library(fastseg)


###################################################
### code chunk number 3: fastseg.Rnw:123-131
###################################################
data(coriell)
head(coriell)

samplenames <- colnames(coriell)[4:5]
data <- as.matrix(coriell[4:5])
#data[is.na(data)] <- median(data, na.rm=TRUE)
chrom <- coriell$Chromosome
maploc <- coriell$Position


###################################################
### code chunk number 4: fastseg.Rnw:144-149
###################################################
data2 <- data[, 1]
res <- fastseg(data2)
head(res)




###################################################
### code chunk number 5: fastseg.Rnw:153-156
###################################################
data2 <- data[1:400, ]
res <- fastseg(data2)
head(res)


###################################################
### code chunk number 6: fastseg.Rnw:162-182
###################################################
library("GenomicRanges")

## with both individuals
gr <- GRanges(seqnames=chrom,
        ranges=IRanges(maploc, end=maploc))
mcols(gr) <- data
colnames(mcols(gr)) <- samplenames
res <- fastseg(gr)
head(res)



## with one individual
gr2 <- gr
data2 <- as.matrix(data[, 1])
colnames(data2) <- "sample1"
mcols(gr2) <- data2
res <- fastseg(gr2)
head(res)



###################################################
### code chunk number 7: fastseg.Rnw:187-201
###################################################
library(oligo)
eSet <- new("ExpressionSet")
assayData(eSet) <- list(intensity=data)

featureData(eSet) <- new("AnnotatedDataFrame", 
        data=data.frame(
                chrom = paste("chr",chrom,sep=""),
                start = maploc, 
                end   = maploc,stringsAsFactors=FALSE))
phenoData(eSet) <- new("AnnotatedDataFrame", 
        data=data.frame(samples=samplenames))
sampleNames(eSet) <- samplenames
res <- fastseg(eSet)
head(res)


###################################################
### code chunk number 8: fastseg.Rnw:205-210
###################################################
data2 <- data[, 1]
res <- fastseg(data2)
head(res)




###################################################
### code chunk number 9: fastseg.Rnw:214-217
###################################################
data2 <- data[1:400, ]
res <- fastseg(data2)
head(res)


###################################################
### code chunk number 10: fastseg.Rnw:225-231
###################################################
## with both individuals
gr <- GRanges(seqnames=chrom,
        ranges=IRanges(maploc, end=maploc))
mcols(gr) <- data
colnames(mcols(gr)) <- samplenames
res <- fastseg(gr,segMedianT=0.2)


###################################################
### code chunk number 11: fastseg.Rnw:237-238
###################################################
segPlot(gr,res, plot.type="w")


###################################################
### code chunk number 12: fastseg.Rnw:245-246
###################################################
segPlot(gr,res, plot.type="s")


###################################################
### code chunk number 13: fastseg.Rnw:259-261
###################################################
data(fastsegData)
system.time(res <- fastseg(fastsegData))


###################################################
### code chunk number 14: fastseg.Rnw:265-266
###################################################
segPlot(fastsegData,res, plot.type="w")


###################################################
### code chunk number 15: fastseg.Rnw:270-273
###################################################
library(DNAcopy)
cna <- DNAcopy::CNA(fastsegData,chrom="chr1",maploc=1:length(fastsegData))
system.time(res2 <- DNAcopy::segment(cna))


###################################################
### code chunk number 16: fastseg.Rnw:277-278
###################################################
plot(res2, plot.type="w", xmaploc=TRUE)


###################################################
### code chunk number 17: fastseg.Rnw:296-297 (eval = FALSE)
###################################################
## toBibtex(citation("fastseg"))


