## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = FALSE,
  comment = "#>",
  eval=TRUE
)

## ---- eval=FALSE--------------------------------------------------------------
#  if(!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("easyreporting")

## -----------------------------------------------------------------------------
library("easyreporting")

## -----------------------------------------------------------------------------
proj.path <- file.path(tempdir(), "bioinfo_report")
bioEr <- easyreporting(filenamePath=proj.path, title="bioinfo_report",
                        author=c("Dario Righelli"))

## -----------------------------------------------------------------------------
mkdTitle(bioEr, title="Loading Counts Data")
mkdCodeChunkComplete(object=bioEr, message=paste0("geneCounts <- importData(sy",
        "stem.file('extdata/GSE134118_Table_S3.xlsx',",
        "package='easyreporting'))"), 
        sourceFilesList=system.file("script/importFunctions.R", 
                                            package="easyreporting"))

## -----------------------------------------------------------------------------
mkdTitle(bioEr, title="Plot PCA on count data", level=2)
mkdCodeChunkComplete(bioEr, 
                        message="EDASeq::plotPCA(as.matrix(geneCounts))")

## -----------------------------------------------------------------------------
mkdTitle(bioEr, "Differential Expression Analysis")
mkdCodeChunkCommented(bioEr, 
    codeMsg="degList <- applyEdgeRExample(counts=geneCounts, 
                    samples=colnames(geneCounts), contrast='Pleura - Broth')", 
    commentMsg=paste0("As we saw from the PCA, the groups are well separated",
        ", so we can perform a Differential Expression analysis with edgeR."),
    sourceFilesList=system.file("script/geneFunctions.R", 
                                package="easyreporting"))

## -----------------------------------------------------------------------------
mkdTitle(bioEr, "MD Plot of DEGs", level=2)
mkdCodeChunkComplete(bioEr, message="limma::plotMD(degList$test)")

## -----------------------------------------------------------------------------
compile(bioEr)

## -----------------------------------------------------------------------------
sessionInfo()

