/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Range
implements Externalizable {
    private static final long serialVersionUID = -155434844308312282L;
    int lb;
    int stride;
    int length;
    int ub;

    public Range() {
        this.lb = 0;
        this.stride = 1;
        this.length = 0;
        this.setUb();
    }

    public Range(int n, int n2) {
        this.lb = n;
        this.stride = 1;
        this.length = Math.max(n2 - n + 1, 0);
        this.setUb();
    }

    public Range(int n, int n2, int n3) {
        if (n3 < 1) {
            throw new IllegalArgumentException("Range(): stride = " + n3 + " illegal");
        }
        this.lb = n;
        this.stride = n3;
        this.length = Math.max((n2 - n + n3) / n3, 0);
        this.setUb();
    }

    public Range(Range range) {
        this.lb = range.lb;
        this.stride = range.stride;
        this.length = range.length;
        this.ub = range.ub;
    }

    public int lb() {
        return this.lb;
    }

    public int ub() {
        return this.ub;
    }

    public int stride() {
        return this.stride;
    }

    public int length() {
        return this.length;
    }

    public boolean contains(int n) {
        return this.lb <= n && n <= this.ub;
    }

    public boolean contains(Range range) {
        return this.lb <= range.lb && range.ub <= this.ub;
    }

    public Range subrange(int n, int n2) {
        if (n < 1) {
            throw new IllegalArgumentException("Range.subrange(): size = " + n + " illegal");
        }
        if (0 > n2 || n2 >= n) {
            throw new IllegalArgumentException("Range.subrange(): rank = " + n2 + " illegal");
        }
        Range range = new Range();
        int n3 = this.length / n;
        int n4 = this.length % n;
        range.lb = n2 < n4 ? this.lb + n2 * ++n3 * this.stride : this.lb + (n4 + n2 * n3) * this.stride;
        range.stride = this.stride;
        range.length = n3;
        range.setUb();
        return range;
    }

    public Range[] subranges(int n) {
        Range range;
        int n2;
        if (n < 1) {
            throw new IllegalArgumentException("Range.subranges(): size = " + n + " illegal");
        }
        Range[] rangeArray = new Range[n];
        int n3 = this.length / n;
        int n4 = this.length % n;
        int n5 = this.lb;
        ++n3;
        for (n2 = 0; n2 < n4; ++n2) {
            range = new Range();
            range.lb = n5;
            n5 += n3 * this.stride;
            range.stride = this.stride;
            range.length = n3;
            range.setUb();
            rangeArray[n2] = range;
        }
        --n3;
        for (n2 = n4; n2 < n; ++n2) {
            range = new Range();
            range.lb = n5;
            n5 += n3 * this.stride;
            range.stride = this.stride;
            range.length = n3;
            range.setUb();
            rangeArray[n2] = range;
        }
        return rangeArray;
    }

    public Range chunk(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Range.chunk(): N1 = " + n + " illegal");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Range.chunk(): N2 = " + n2 + " illegal");
        }
        Range range = new Range();
        range.lb = this.lb + n * this.stride;
        range.stride = this.stride;
        range.length = Math.min(n2, Math.max(0, this.length - n));
        range.setUb();
        return range;
    }

    public boolean equals(Object object) {
        return object instanceof Range && this.lb == ((Range)object).lb && this.stride == ((Range)object).stride && this.length == ((Range)object).length;
    }

    public int hashCode() {
        return ((this.lb << 10) + this.stride << 10) + this.length;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.lb);
        stringBuilder.append("..");
        stringBuilder.append(this.ub);
        if (this.stride > 1) {
            stringBuilder.append(';');
            stringBuilder.append(this.stride);
        }
        return stringBuilder.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.lb);
        objectOutput.writeInt(this.stride);
        objectOutput.writeInt(this.length);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.lb = objectInput.readInt();
        this.stride = objectInput.readInt();
        this.length = objectInput.readInt();
        this.setUb();
    }

    private void setUb() {
        this.ub = this.lb + (this.length - 1) * this.stride;
    }
}

