/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.replica;

import edu.rit.mp.ByteBuf;
import edu.rit.mp.buf.ByteItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.reduction.ByteOp;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class ReplicatedByte
extends Number {
    private ByteOp myOp;
    private AtomicInteger myValue;
    private int myTag;
    private Comm myComm;
    private Receiver myReceiver;

    public ReplicatedByte(ByteOp byteOp) {
        this(byteOp, 0, 0, Comm.world());
    }

    public ReplicatedByte(ByteOp byteOp, byte by) {
        this(byteOp, by, 0, Comm.world());
    }

    public ReplicatedByte(ByteOp byteOp, byte by, int n) {
        this(byteOp, by, n, Comm.world());
    }

    public ReplicatedByte(ByteOp byteOp, byte by, int n, Comm comm) {
        if (byteOp == null) {
            throw new NullPointerException("ReplicatedByte(): op is null");
        }
        if (comm == null) {
            throw new NullPointerException("ReplicatedByte(): comm is null");
        }
        this.myOp = byteOp;
        this.myValue = new AtomicInteger(by);
        this.myTag = n;
        this.myComm = comm;
        this.myReceiver = new Receiver();
        this.myReceiver.setDaemon(true);
        this.myReceiver.start();
    }

    public byte get() {
        return (byte)this.myValue.get();
    }

    public byte reduce(byte by) throws IOException {
        byte by2;
        byte by3;
        while (!this.myValue.compareAndSet(by3 = (byte)this.myValue.get(), by2 = this.myOp.op(by3, by))) {
        }
        if (by2 != by3) {
            this.myComm.floodSend(this.myTag, ByteBuf.buffer(by2));
        }
        return by2;
    }

    public String toString() {
        return Byte.toString(this.get());
    }

    public int intValue() {
        return this.get();
    }

    public long longValue() {
        return this.get();
    }

    public float floatValue() {
        return this.get();
    }

    public double doubleValue() {
        return this.get();
    }

    private class Receiver
    extends Thread {
        private Receiver() {
        }

        public void run() {
            ByteItemBuf byteItemBuf = ByteBuf.buffer();
            try {
                while (true) {
                    byte by;
                    byte by2;
                    ReplicatedByte.this.myComm.floodReceive(ReplicatedByte.this.myTag, byteItemBuf);
                    do {
                        by2 = (byte)ReplicatedByte.this.myValue.get();
                        by = ReplicatedByte.this.myOp.op(by2, byteItemBuf.item);
                    } while (!ReplicatedByte.this.myValue.compareAndSet(by2, by));
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
                return;
            }
        }
    }
}

