/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mri;

import edu.rit.image.PJGGrayImage;
import edu.rit.mri.PixelTissues;
import edu.rit.mri.TissuesDataSetReader;
import edu.rit.swing.DisplayableFrame;
import java.io.File;

public class R1Image {
    private R1Image() {
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        int n2;
        if (stringArray.length != 3) {
            R1Image.usage();
        }
        File file = new File(stringArray[0]);
        double d = Double.parseDouble(stringArray[1]);
        double d2 = Double.parseDouble(stringArray[2]);
        TissuesDataSetReader tissuesDataSetReader = new TissuesDataSetReader(file);
        int n3 = tissuesDataSetReader.getHeight();
        int n4 = tissuesDataSetReader.getWidth();
        double[][] dArray = new double[n3][n4];
        byte[][] byArray = new byte[n3][n4];
        PJGGrayImage pJGGrayImage = new PJGGrayImage(n3, n4, byArray);
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                PixelTissues pixelTissues = tissuesDataSetReader.getPixelTissues(tissuesDataSetReader.indexFor(n2, n));
                if (pixelTissues == null) continue;
                pJGGrayImage.setPixel(n2, n, 0.25f);
                double d5 = 0.0;
                for (int i = 0; i < pixelTissues.numTissues(); ++i) {
                    double d6 = pixelTissues.R1(i);
                    if (!(d <= d6) || !(d6 <= d2)) continue;
                    d5 += pixelTissues.rho(i);
                }
                if (!(d5 > 0.0)) continue;
                d3 = Math.min(d3, d5);
                d4 = Math.max(d4, d5);
                dArray[n2][n] = d5;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                if (!(dArray[n2][n] > 0.0)) continue;
                pJGGrayImage.setPixel(n2, n, (float)((dArray[n2][n] - d3) / (d4 - d3) * 0.5 + 0.5));
            }
        }
        tissuesDataSetReader.close();
        new DisplayableFrame("Tissues with " + stringArray[1] + " <= R1 < " + stringArray[2], pJGGrayImage.getDisplayable(), 3).setVisible(true);
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.mri.test.R1Image <tissuesfile> <R1_lower> <R1_upper>");
        System.err.println("<tissuesfile> = Tissues data set file");
        System.err.println("<R1_lower> = Lower R1 spin-lattice relaxation rate (1/sec)");
        System.err.println("<R1_upper> = Upper R1 spin-lattice relaxation rate (1/sec)");
        System.exit(1);
    }
}

