/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.hyb.fractal;

import edu.rit.color.HSB;
import edu.rit.image.PJGColorImage;
import edu.rit.image.PJGImage;
import edu.rit.io.Files;
import edu.rit.pj.Comm;
import edu.rit.pj.HybridTeam;
import edu.rit.pj.WorkerIntegerForLoop;
import edu.rit.pj.WorkerRegion;
import edu.rit.util.Range;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;

public class MandelbrotSetHyb {
    static Comm world;
    static int rank;
    static int width;
    static int height;
    static double xcenter;
    static double ycenter;
    static double resolution;
    static int maxiter;
    static double gamma;
    static File filename;
    static int xoffset;
    static int yoffset;
    static int[] huetable;

    private MandelbrotSetHyb() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        rank = world.rank();
        if (stringArray.length != 8) {
            MandelbrotSetHyb.usage();
        }
        width = Integer.parseInt(stringArray[0]);
        height = Integer.parseInt(stringArray[1]);
        xcenter = Double.parseDouble(stringArray[2]);
        ycenter = Double.parseDouble(stringArray[3]);
        resolution = Double.parseDouble(stringArray[4]);
        maxiter = Integer.parseInt(stringArray[5]);
        gamma = Double.parseDouble(stringArray[6]);
        filename = new File(stringArray[7]);
        xoffset = -(width - 1) / 2;
        yoffset = (height - 1) / 2;
        huetable = new int[maxiter + 1];
        for (int i = 0; i < maxiter; ++i) {
            MandelbrotSetHyb.huetable[i] = HSB.pack((float)Math.pow((double)i / (double)maxiter, gamma), 1.0f, 1.0f);
        }
        MandelbrotSetHyb.huetable[MandelbrotSetHyb.maxiter] = HSB.pack(1.0f, 1.0f, 0.0f);
        long l2 = System.currentTimeMillis();
        new HybridTeam().execute(new WorkerRegion(){

            public void run() throws Exception {
                this.execute(0, height - 1, new WorkerIntegerForLoop(){
                    int[][] matrix;
                    int[][] slice;
                    PJGColorImage image;
                    PJGImage.Writer writer;

                    public void start() throws Exception {
                        this.matrix = new int[height][];
                        this.image = new PJGColorImage(height, width, this.matrix);
                        this.writer = this.image.prepareToWrite(new BufferedOutputStream(new FileOutputStream(Files.fileForRank(filename, this.getThreadIndex()))));
                    }

                    public void run(int n, int n2) throws Exception {
                        Range range = new Range(n, n2);
                        int n3 = range.length();
                        if (this.slice == null || this.slice.length < n3) {
                            this.slice = new int[n3][width];
                        }
                        for (int i = n; i <= n2; ++i) {
                            int[] nArray = this.slice[i - n];
                            double d = ycenter + (double)(yoffset - i) / resolution;
                            for (int j = 0; j < width; ++j) {
                                int n4;
                                double d2 = xcenter + (double)(xoffset + j) / resolution;
                                double d3 = 0.0;
                                double d4 = 0.0;
                                double d5 = 0.0;
                                double d6 = 0.0;
                                double d7 = 0.0;
                                for (n4 = 0; n4 < maxiter && d7 <= 4.0; ++n4) {
                                    d5 = d3 * d3 - d4 * d4 + d2;
                                    d6 = 2.0 * d3 * d4 + d;
                                    d7 = d5 * d5 + d6 * d6;
                                    d3 = d5;
                                    d4 = d6;
                                }
                                nArray[j] = huetable[n4];
                            }
                        }
                        System.arraycopy(this.slice, 0, this.matrix, n, n3);
                        this.writer.writeRowSlice(range);
                    }

                    public void finish() throws Exception {
                        this.writer.close();
                    }
                });
            }
        });
        long l3 = System.currentTimeMillis();
        long l4 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec pre " + rank);
        System.out.println(l3 - l2 + " msec calc " + rank);
        System.out.println(l4 - l3 + " msec post " + rank);
        System.out.println(l4 - l + " msec total " + rank);
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=<Kp> -Dpj.nt=<Kt> [-Dpj.schedule=<schedule>] edu.rit.hyb.fractal.MandelbrotSetHyb <width> <height> <xcenter> <ycenter> <resolution> <maxiter> <gamma> <filename>");
        System.err.println("<Kp> = Number of parallel processes");
        System.err.println("<Kt> = Number of parallel threads per process");
        System.err.println("<schedule> = Load balancing schedule");
        System.err.println("<width> = Image width (pixels)");
        System.err.println("<height> = Image height (pixels)");
        System.err.println("<xcenter> = X coordinate of center point");
        System.err.println("<ycenter> = Y coordinate of center point");
        System.err.println("<resolution> = Pixels per unit");
        System.err.println("<maxiter> = Maximum number of iterations");
        System.err.println("<gamma> = Used to calculate pixel hues");
        System.err.println("<filename> = PJG image file name");
        System.exit(1);
    }
}

