/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.phyl;

import edu.rit.compbio.phyl.DnaSequenceList;
import edu.rit.compbio.phyl.DnaSequenceTree;
import edu.rit.compbio.phyl.FitchParsimony;
import edu.rit.compbio.phyl.JukesCantorDistance;
import edu.rit.compbio.phyl.MaximumParsimonyBnbSmp;
import edu.rit.compbio.phyl.MaximumParsimonyResults;
import edu.rit.compbio.phyl.Results;
import edu.rit.compbio.phyl.Upgma;
import edu.rit.pj.Comm;
import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.SharedInteger;
import java.io.File;

public class PhylogenyParsBnbSmp {
    private static final int MAX_START_LEVEL = 6;
    private static File infile;
    private static File outdir;
    private static int N;
    private static int T;
    private static DnaSequenceList seqList;
    private static DnaSequenceList sortedList;
    private static DnaSequenceList excisedList;
    private static SharedInteger bound;
    private static MaximumParsimonyResults globalResults;
    private static int startLevel;
    private static int vertexCount;
    private static int K;

    private PhylogenyParsBnbSmp() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        if (stringArray.length < 2 || stringArray.length > 4) {
            PhylogenyParsBnbSmp.usage();
        }
        infile = new File(stringArray[0]);
        outdir = new File(stringArray[1]);
        T = 100;
        if (stringArray.length >= 4) {
            T = Integer.parseInt(stringArray[3]);
        }
        seqList = DnaSequenceList.read(infile);
        N = seqList.length();
        if (stringArray.length >= 3) {
            N = Integer.parseInt(stringArray[2]);
        }
        seqList.truncate(N);
        DnaSequenceTree dnaSequenceTree = Upgma.buildTree(seqList, new JukesCantorDistance());
        int n = FitchParsimony.computeScore(dnaSequenceTree);
        sortedList = dnaSequenceTree.toList();
        excisedList = new DnaSequenceList(sortedList);
        int n2 = excisedList.exciseUninformativeSites();
        bound = MaximumParsimonyBnbSmp.createBoundVariable(n - n2);
        globalResults = new MaximumParsimonyResults(T);
        startLevel = Math.min(6, N - 1);
        vertexCount = 1;
        for (int i = 2 * startLevel - 1; i > 1; i -= 2) {
            vertexCount *= i;
        }
        long l2 = System.currentTimeMillis();
        K = ParallelTeam.getDefaultThreadCount();
        new ParallelTeam(K).execute(new ParallelRegion(){

            public void run() throws Exception {
                this.execute(0, vertexCount - 1, new IntegerForLoop(){
                    MaximumParsimonyResults results;
                    MaximumParsimonyBnbSmp searcher;
                    long p0;
                    long p1;
                    long p2;
                    long p3;
                    long p4;
                    long p5;
                    long p6;
                    long p7;
                    long p8;
                    long p9;
                    long pa;
                    long pb;
                    long pc;
                    long pd;
                    long pe;
                    long pf;

                    public IntegerSchedule schedule() {
                        return IntegerSchedule.runtime(IntegerSchedule.dynamic(1));
                    }

                    public void start() {
                        this.results = new MaximumParsimonyResults(T);
                        this.searcher = new MaximumParsimonyBnbSmp(excisedList, bound, this.results);
                    }

                    public void run(int n, int n2) {
                        this.searcher.findTrees(startLevel, n, n2);
                    }

                    public void finish() {
                        globalResults.addAll(this.results);
                    }
                });
            }
        });
        globalResults.score(globalResults.score() + n2);
        long l3 = System.currentTimeMillis();
        Results.report(outdir, "edu.rit.compbio.phyl.PhylogenyParsBnbSmp", Comm.world().host(), K, infile, seqList, sortedList, n, T, globalResults, l, l2, l3);
        long l4 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec pre");
        System.out.println(l3 - l2 + " msec calc");
        System.out.println(l4 - l3 + " msec post");
        System.out.println(l4 - l + " msec total");
    }

    private static void usage() {
        System.err.println("Usage: java [-Dpj.nt=<Kt>] [-Dpj.schedule=<schedule>] edu.rit.compbio.phyl.PhylogenyParsBnbSmp <infile> <outdir> [<N> [<T>]]");
        System.err.println("<Kt> = Number of parallel threads (default: number of CPUs)");
        System.err.println("<schedule> = Load balancing schedule (default: dynamic(1))");
        System.err.println("<infile> = Input DNA sequence list file name");
        System.err.println("<outdir> = Output directory name");
        System.err.println("<N> = Number of DNA sequences to use (default: all)");
        System.err.println("<T> = Number of trees to report (default: 100)");
        System.exit(1);
    }
}

