## ---- eval= FALSE-------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly=TRUE)){
#      install.packages("BiocManager")}
#  BiocManager::install("celda")

## ---- eval = TRUE, message = FALSE, warning = FALSE---------------------------
library(celda)

## ---- eval = FALSE------------------------------------------------------------
#  help(package = celda)

## ---- eval = TRUE, message = FALSE--------------------------------------------
library(M3DExampleData)
counts <- M3DExampleData::Mmus_example_list$data
# Subset 500 genes for fast clustering
counts <- as.matrix(counts[1501:2000, ])
# Cluster genes ans samples each into 10 modules
cm <- celda_CG(counts = counts, L = 10, K = 10, verbose = FALSE)

## ---- eval = TRUE, message = FALSE--------------------------------------------
# Get features matrix and cluster assignments
factorized <- factorizeMatrix(counts, cm)
features <- factorized$proportions$cell
class <- clusters(cm)$z

## ---- eval = TRUE, message = FALSE--------------------------------------------

DecTree <- findMarkers(features,
    class,
    oneoffMetric = "modified F1",
    threshold = 0.95,
    reuseFeatures = FALSE,
    altSplit = TRUE,
    consecutiveOneoff = FALSE)

## ---- eval = TRUE, message = FALSE--------------------------------------------
plotDendro(DecTree,
    classLabel = NULL,
    addSensPrec = TRUE,
    leafSize = 24,
    boxSize = 7,
    boxColor = "black")

## ---- eval = TRUE, message = FALSE--------------------------------------------
plotDendro(DecTree,
    classLabel = "1",
    addSensPrec = TRUE,
    leafSize = 15,
    boxSize = 7,
    boxColor = "black")

## ---- eval = TRUE, message = FALSE--------------------------------------------
head(getDecisions(DecTree$rules, features))

## ---- eval = TRUE, message = FALSE--------------------------------------------
# Run with a hierarchichal split
cellTypes <- list(metaLabel = c("4", "5", "1"))
DecTreeMeta <- findMarkers(features,
    class,
    cellTypes,
    oneoffMetric = "modified F1",
    threshold = 1,
    reuseFeatures = F,
    consecutiveOneoff = FALSE)
plotDendro(DecTreeMeta)

## -----------------------------------------------------------------------------
sessionInfo()

