## ----echo = FALSE, include = FALSE-----------------------------------------
knitr::opts_chunk$set(tidy = FALSE, cache = TRUE, dev = "png",
                      message = FALSE, error = FALSE, warning = TRUE)

## --------------------------------------------------------------------------
library(SummarizedBenchmark)
library(magrittr)

## --------------------------------------------------------------------------
bdslow <- BenchDesign(data = tdat) %>%
    addMethod("slowMethod", function() { Sys.sleep(5); rnorm(5) },
              post = list(keepSlow = identity,
                          makeSlower = function(x) { Sys.sleep(5); x })) %>%
    addMethod("fastMethod", function() { rnorm(5) },
              post = list(keepFast = identity,
                          makeSlower = function(x) { Sys.sleep(5); x }))

## ---- message = TRUE-------------------------------------------------------
bpp <- SerialParam()
bptimeout(bpp) <- 1

sbep <- buildBench(bdslow, parallel = TRUE, BPPARAM = bpp)

## --------------------------------------------------------------------------
sbep

## --------------------------------------------------------------------------
sapply(assayNames(sbep), assay, x = sbep, simplify = FALSE)

## --------------------------------------------------------------------------
names(metadata(sbep)$sessions[[1]])

## --------------------------------------------------------------------------
sess1res <- metadata(sbep)$sessions[[1]]$results
simplify2array(sess1res)

## --------------------------------------------------------------------------
sess1res$slowMethod$keepSlow

