## ----setup, include=FALSE--------------------------------------------------
knitr::opts_chunk$set(dpi = 300)
knitr::opts_chunk$set(cache=FALSE)

## ---- echo = FALSE,hide=TRUE, message=FALSE,warning=FALSE------------------
devtools::load_all(".")

## ---- eval = FALSE---------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly=TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("StarBioTrek")

## ---- eval = TRUE----------------------------------------------------------
library(graphite)
sel<-pathwayDatabases()

## ---- eval = TRUE, echo = FALSE--------------------------------------------
knitr::kable(sel, digits = 2,
             caption = "List of patwhay databases and species",row.names = FALSE)

## ---- eval = TRUE----------------------------------------------------------
species="hsapiens"
pathwaydb="kegg"
path<-GetData(species,pathwaydb)

## ---- eval = FALSE---------------------------------------------------------
#  pathway_ALLGENE<-GetPathData(path_ALL=path[1:3])

## ---- eval = FALSE---------------------------------------------------------
#  pathway_net<-GetPathNet(path_ALL=path[1:3])

## ---- eval = TRUE----------------------------------------------------------
pathway<-ConvertedIDgenes(path_ALL=path[1:10])

## ---- eval = TRUE----------------------------------------------------------
organismID="Saccharomyces_cerevisiae"
netw<-getNETdata(network="SHpd",organismID)

## ---- eval = TRUE----------------------------------------------------------
lista_net<-pathnet(genes.by.pathway=pathway[1:5],data=netw)

## ---- eval = TRUE----------------------------------------------------------
list_path<-listpathnet(lista_net=lista_net,pathway=pathway[1:5])

## ---- eval = TRUE----------------------------------------------------------
list_path_gene<-GE_matrix(DataMatrix=tumo[,1:2],genes.by.pathway=pathway[1:10])

## ---- eval = TRUE----------------------------------------------------------
list_path_plot<-GE_matrix_mean(DataMatrix=tumo[,1:2],genes.by.pathway=pathway[1:10])

## ---- eval = FALSE---------------------------------------------------------
#  score_mean<-average(pathwayexpsubset=list_path_gene)

## ---- eval = TRUE----------------------------------------------------------
score_st_dev<-stdv(gslist=list_path_gene)

## ---- eval = FALSE---------------------------------------------------------
#  score_euc_distance<-eucdistcrtlk(dataFilt=tumo[,1:2],pathway_exp=pathway[1:10])

## ---- eval = FALSE---------------------------------------------------------
#  cross_talk_st_dv<-dsscorecrtlk(dataFilt=tumo[,1:2],pathway_exp=pathway[1:10])

## ---- eval = FALSE---------------------------------------------------------
#  nf <- 60
#  res_class<-svm_classification(TCGA_matrix=score_euc_dista[1:30,],nfs=nf,
#  normal=colnames(norm[,1:10]),tumour=colnames(tumo[,1:10]))

## ---- eval = FALSE---------------------------------------------------------
#   DRIVER_SP<-IPPI(pathax=pathway_matrix[,1:3],netwa=netw_IPPI[1:50000,])

## ---- eval = TRUE----------------------------------------------------------
formatplot<-plotcrosstalk(pathway_plot=pathway[1:6],gs_expre=tumo)
library(qgraph)
qgraph(formatplot[[1]], minimum = 0.25, cut = 0.6, vsize = 5, groups = formatplot[[2]], legend = TRUE, borders = FALSE,layoutScale=c(0.8,0.8))

## ---- eval = TRUE----------------------------------------------------------
qgraph(formatplot[[1]],groups=formatplot[[2]], layout="spring", diag = FALSE,
cut = 0.6,legend.cex = 0.5,vsize = 6,layoutScale=c(0.8,0.8))

## ---- eval = FALSE---------------------------------------------------------
#  formatplot<-plotcrosstalk(pathway_plot=pathway[1:6],gs_expre=tumo)
#  score<-runif(length(formatplot[[2]]), min=-10, max=+10)
#  circleplot(preplot=formatplot,scoregene=score)

## ---- fig.width=6, fig.height=4, echo=FALSE, fig.align="center"------------
library(png)
library(grid)
img <- readPNG("circleplot.png")
grid.raster(img)

## ----sessionInfo-----------------------------------------------------------
sessionInfo()

