df <- data.frame(
    Title = sprintf("Blueprint/Encode RNA-seq %s", c("logcounts", "colData")), 
    Description = sprintf("%s 259 RNA-seq samples of pure stroma and immune cells generated by Blueprint and ENCODE", 
        c("Matrix of log-normalized expression values from", "Per-sample metadata containing cell type labels of")),
    RDataPath = file.path("SingleR", "blueprint_encode","1.2.0", c("logcounts.rds", "coldata.rds")),
    BiocVersion="3.11", 
    Genome=NA, 
    SourceType="RDA", 
    SourceUrl="https://github.com/dviraran/SingleR/tree/master/data",
    SourceVersion="blueprint_encode.rda",
    Species="Homo sapiens",
    TaxonomyId="9606",
    Coordinate_1_based=NA,
    DataProvider="Dvir Aran",
    Maintainer="Friederike Duendar <frd2007@med.cornell.edu>",
    RDataClass=c("matrix", "DataFrame"),
    DispatchClass="Rds", 
    stringsAsFactors = FALSE
)

## Only saving the column metadata for 1.2.0,
## as logcounts are the same for 1.0.0. 
write.csv(file="../extdata/1.2.0/metadata-blueprint_encode.csv", df[2,], row.names=FALSE)
