## ----setup, include = FALSE------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
library("SharedObject")

## --------------------------------------------------------------------------
library(parallel)
## Initiate the cluster
cl=makeCluster(1)
## create data
n=3
A=matrix(runif(n^2),n,n)
## create shared object
A_shr=share(A)
## export the shared object
clusterExport(cl,"A_shr")

stopCluster(cl)

## --------------------------------------------------------------------------
## check the data 
A 
A_shr 
## check the properties
attributes(A) 
attributes(A_shr) 
## check the class 
class(A)
class(A_shr) 

## --------------------------------------------------------------------------
## Check if an object is of an ALTREP class
is.altrep(A)
is.altrep(A_shr)

## Check if an object is a shared object
## This works for both vector and data.frame
is.shared(A)
is.shared(A_shr)

## --------------------------------------------------------------------------
## get a summary report
getSharedProperties(A_shr)

## Internal function to check the properties
## All properties can be accessed via the similar way
.getProperty(A_shr,"dataId")
.getProperty(A_shr,"processId")
.getProperty(A_shr,"typeId")

## Public function to check the properties
getCopyOnWrite(A_shr)
getSharedSubset(A_shr)
getSharedCopy(A_shr)

## --------------------------------------------------------------------------
A_shr2=A_shr
A_shr[1,1]=10

A_shr
A_shr2

## --------------------------------------------------------------------------
A_shr=share(A,copyOnWrite=FALSE)
A_shr2=A_shr
A_shr[1,1]=10

A_shr
A_shr2

## --------------------------------------------------------------------------
A_shr=share(A,copyOnWrite=FALSE)
-A_shr
A_shr

## --------------------------------------------------------------------------
A_shr=share(A,copyOnWrite=FALSE)
#Assign A_shr to another object
A_shr2=A_shr
#change the value of A_shr
A_shr[1,1]=10
#Both A_shr and A_shr2 are affected
A_shr
A_shr2
#Enable copy-on-write
setCopyOnWrite(A_shr,TRUE)
#The unary function does not affect the variable A_shr
-A_shr
A_shr

getCopyOnWrite(A_shr)

## --------------------------------------------------------------------------
A_shr=share(A,sharedSubset=FALSE,sharedCopy=TRUE)
getSharedProperties(A_shr)

## --------------------------------------------------------------------------
sessionInfo()

