/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.fastq;

import java.io.File;
import java.io.PrintStream;
import net.sf.picard.PicardException;
import net.sf.picard.fastq.FastqRecord;
import net.sf.picard.io.IoUtil;

public class FastqWriter {
    private final File file;
    private final PrintStream writer;

    public FastqWriter(File file) {
        this.file = file;
        this.writer = new PrintStream(IoUtil.openFileForWriting(file));
    }

    public void write(FastqRecord rec) {
        this.writer.print("@");
        this.writer.println(rec.getReadHeader());
        this.writer.println(rec.getReadString());
        this.writer.print("+");
        this.writer.println(rec.getBaseQualityHeader() == null ? "" : rec.getBaseQualityHeader());
        this.writer.println(rec.getBaseQualityString());
        if (this.writer.checkError()) {
            throw new PicardException("Error in writing file " + this.file);
        }
    }

    public void close() {
        this.writer.close();
    }
}

