/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis;

import java.io.File;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.io.IoUtil;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.util.Histogram;
import net.sf.picard.util.RExecutor;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;

public class MeanQualityByCycle
extends CommandLineProgram {
    @Option(shortName="I", doc="The input BAM file to process")
    public File INPUT;
    @Option(shortName="O", doc="A file to write the table of qualities to")
    public File OUTPUT;
    @Option(shortName="CHART", doc="A file (with .pdf extension) to write the chart to")
    public File CHART_OUTPUT;
    @Option(doc="If set to true calculate mean quality over aligned reads only")
    public boolean ALIGNED_READS_ONLY = false;
    @Option(doc="If set to true calculate mean quality over PF reads only")
    public boolean PF_READS_ONLY = false;
    @Option(doc="Stop after processing N reads, mainly for debugging.")
    public int STOP_AFTER = 0;

    public static void main(String[] args) {
        System.exit(new MeanQualityByCycle().instanceMain(args));
    }

    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        IoUtil.assertFileIsWritable(this.CHART_OUTPUT);
        SAMFileReader in = new SAMFileReader(this.INPUT);
        HistogramGenerator q = new HistogramGenerator(false);
        HistogramGenerator oq = new HistogramGenerator(true);
        int i = 0;
        for (SAMRecord rec : in) {
            if (this.PF_READS_ONLY && rec.getReadFailsVendorQualityCheckFlag() || this.ALIGNED_READS_ONLY && rec.getReadUnmappedFlag()) continue;
            q.addRecord(rec);
            oq.addRecord(rec);
            if (this.STOP_AFTER <= 0 || ++i < this.STOP_AFTER) continue;
            break;
        }
        MetricsFile metrics = this.getMetricsFile();
        metrics.addHistogram(q.getMeanQualityHistogram());
        if (!oq.isEmpty()) {
            metrics.addHistogram(oq.getMeanQualityHistogram());
        }
        metrics.write(this.OUTPUT);
        int rResult = RExecutor.executeFromClasspath("net/sf/picard/analysis/meanQualityByCycle.R", this.OUTPUT.getAbsolutePath(), this.CHART_OUTPUT.getAbsolutePath(), this.INPUT.getName());
        if (rResult != 0) {
            throw new PicardException("R script meanQualityByCycle.R failed with return code " + rResult);
        }
        return 0;
    }

    private static class HistogramGenerator {
        final boolean useOriginalQualities;
        Histogram<Integer> totalQ = new Histogram();
        Histogram<Integer> countOfBases = new Histogram();

        private HistogramGenerator(boolean useOriginalQualities) {
            this.useOriginalQualities = useOriginalQualities;
        }

        void addRecord(SAMRecord rec) {
            byte[] quals;
            byte[] byArray = quals = this.useOriginalQualities ? rec.getOriginalBaseQualities() : rec.getBaseQualities();
            if (quals == null) {
                return;
            }
            int length = quals.length;
            boolean rc = !rec.getReadUnmappedFlag() && rec.getReadNegativeStrandFlag();
            for (int i = 0; i < length; ++i) {
                int cycle;
                int n = cycle = rc ? length - i : i + 1;
                if (rec.getReadPairedFlag() && rec.getSecondOfPairFlag()) {
                    cycle = rec.getReadLength() + cycle;
                }
                this.totalQ.increment(cycle, quals[i]);
                this.countOfBases.increment(cycle);
            }
        }

        Histogram<Integer> getMeanQualityHistogram() {
            String label = this.useOriginalQualities ? "MEAN_ORIGINAL_QUALITY" : "MEAN_QUALITY";
            Histogram<Integer> meanQualities = new Histogram<Integer>("CYCLE", label);
            for (Integer cycle : this.countOfBases.keySet()) {
                meanQualities.increment(cycle, ((Histogram.Bin)this.totalQ.get(cycle)).getValue() / ((Histogram.Bin)this.countOfBases.get(cycle)).getValue());
            }
            return meanQualities;
        }

        boolean isEmpty() {
            return this.totalQ.isEmpty();
        }
    }
}

