/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import org.biojava3.core.sequence.DNASequence;
import org.biojava3.core.sequence.ProteinSequence;
import org.biojava3.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava3.core.sequence.compound.DNACompoundSet;
import org.biojava3.core.sequence.io.DNASequenceCreator;
import org.biojava3.core.sequence.io.FastaReader;
import org.biojava3.core.sequence.io.FastaSequenceParser;
import org.biojava3.core.sequence.io.FileProxyDNASequenceCreator;
import org.biojava3.core.sequence.io.GenericFastaHeaderParser;
import org.biojava3.core.sequence.io.ProteinSequenceCreator;

public class FastaReaderHelper {
    public static LinkedHashMap<String, DNASequence> readFastaDNASequence(File file, boolean lazySequenceLoad) throws Exception {
        if (!lazySequenceLoad) {
            return FastaReaderHelper.readFastaDNASequence(file);
        }
        FastaReader fastaProxyReader = new FastaReader(file, new GenericFastaHeaderParser(), new FileProxyDNASequenceCreator(file, DNACompoundSet.getDNACompoundSet(), new FastaSequenceParser()));
        return fastaProxyReader.process();
    }

    public static LinkedHashMap<String, ProteinSequence> readFastaProteinSequence(File file) throws Exception {
        FileInputStream inStream = new FileInputStream(file);
        LinkedHashMap<String, ProteinSequence> proteinSequences = FastaReaderHelper.readFastaProteinSequence(inStream);
        inStream.close();
        return proteinSequences;
    }

    public static LinkedHashMap<String, ProteinSequence> readFastaProteinSequence(InputStream inStream) throws Exception {
        FastaReader fastaReader = new FastaReader(inStream, new GenericFastaHeaderParser(), new ProteinSequenceCreator(AminoAcidCompoundSet.getAminoAcidCompoundSet()));
        return fastaReader.process();
    }

    public static LinkedHashMap<String, DNASequence> readFastaDNASequence(InputStream inStream) throws Exception {
        FastaReader fastaReader = new FastaReader(inStream, new GenericFastaHeaderParser(), new DNASequenceCreator(DNACompoundSet.getDNACompoundSet()));
        return fastaReader.process();
    }

    public static LinkedHashMap<String, DNASequence> readFastaDNASequence(File file) throws Exception {
        FileInputStream inStream = new FileInputStream(file);
        LinkedHashMap<String, DNASequence> dnaSequences = FastaReaderHelper.readFastaDNASequence(inStream);
        inStream.close();
        return dnaSequences;
    }

    public static void main(String[] args) throws Exception {
        LinkedHashMap<String, DNASequence> dnaSequences = FastaReaderHelper.readFastaDNASequence(new File("fasta.fna"));
        for (DNASequence sequence : dnaSequences.values()) {
            sequence.getRNASequence().getProteinSequence().getSequenceAsString();
        }
    }
}

