/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.io;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.biojava3.core.sequence.AccessionID;
import org.biojava3.core.sequence.ChromosomeSequence;
import org.biojava3.core.sequence.ExonSequence;
import org.biojava3.core.sequence.GeneSequence;
import org.biojava3.core.sequence.Strand;
import org.biojava3.core.sequence.compound.NucleotideCompound;
import org.biojava3.core.sequence.io.GenericFastaHeaderFormat;
import org.biojava3.core.sequence.io.template.FastaHeaderFormatInterface;

public class FastaGeneWriter {
    boolean showExonUppercase = false;
    OutputStream os;
    Collection<GeneSequence> sequences;
    FastaHeaderFormatInterface<GeneSequence, NucleotideCompound> headerFormat;
    private int lineLength = 60;

    public FastaGeneWriter(OutputStream os, Collection<GeneSequence> sequences, FastaHeaderFormatInterface<GeneSequence, NucleotideCompound> headerFormat, boolean showExonUppercase) {
        this(os, sequences, headerFormat, showExonUppercase, 60);
    }

    public FastaGeneWriter(OutputStream os, Collection<GeneSequence> sequences, FastaHeaderFormatInterface<GeneSequence, NucleotideCompound> headerFormat, boolean showExonUppercase, int lineLength) {
        this.os = os;
        this.sequences = sequences;
        this.headerFormat = headerFormat;
        this.lineLength = lineLength;
        this.showExonUppercase = showExonUppercase;
    }

    public void process() throws Exception {
        byte[] lineSep = System.getProperty("line.separator").getBytes();
        for (GeneSequence sequence : this.sequences) {
            String header = this.headerFormat.getHeader(sequence);
            this.os.write(62);
            this.os.write(header.getBytes());
            this.os.write(lineSep);
            int compoundCount = 0;
            String seq = "";
            seq = sequence.getSequence5PrimeTo3Prime().getSequenceAsString();
            if (this.showExonUppercase) {
                StringBuilder sb = new StringBuilder(seq.toLowerCase());
                int geneBioBegin = sequence.getBioBegin();
                int geneBioEnd = sequence.getBioEnd();
                for (ExonSequence exonSequence : sequence.getExonSequences()) {
                    int featureBioBegin = 0;
                    int featureBioEnd = 0;
                    if (sequence.getStrand() != Strand.NEGATIVE) {
                        featureBioBegin = exonSequence.getBioBegin() - geneBioBegin;
                        featureBioEnd = exonSequence.getBioEnd() - geneBioBegin;
                    } else {
                        featureBioBegin = geneBioEnd - exonSequence.getBioEnd();
                        featureBioEnd = geneBioEnd - exonSequence.getBioBegin();
                    }
                    if (featureBioBegin < 0 || featureBioEnd < 0 || featureBioEnd > sb.length() || featureBioBegin > sb.length()) {
                        System.out.println("Bad Feature " + sequence.getAccession().toString() + " " + (Object)((Object)sequence.getStrand()) + " " + geneBioBegin + " " + geneBioEnd + " " + exonSequence.getBioBegin() + " " + exonSequence.getBioEnd());
                        continue;
                    }
                    for (int i = featureBioBegin; i <= featureBioEnd; ++i) {
                        char ch = sb.charAt(i);
                        String temp = ch + "";
                        ch = temp.toUpperCase().charAt(0);
                        sb.setCharAt(i, ch);
                    }
                }
                seq = sb.toString();
            }
            for (int i = 0; i < seq.length(); ++i) {
                this.os.write(seq.charAt(i));
                if (++compoundCount != this.lineLength) continue;
                this.os.write(lineSep);
                compoundCount = 0;
            }
            if (sequence.getLength() % this.getLineLength() == 0) continue;
            this.os.write(lineSep);
        }
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public void setLineLength(int lineLength) {
        this.lineLength = lineLength;
    }

    public static void main(String[] args) {
        try {
            ArrayList<GeneSequence> sequences = new ArrayList<GeneSequence>();
            ChromosomeSequence seq1 = new ChromosomeSequence("ATATATATATATATATATATATATATATATATACGCGCGCGCGCGCGCGCGCGCGCGCGCGCGCATATATATATATATATATATATACGCGCGCGCGCGCGCGCATATATATATATATATATATATATATATATATACGCGCGCGCGCGCGCGCGCGCGCGCGCGCGCATATATATATATATATATATATACGCGCGCGCGCGCGCGC");
            GeneSequence gene1 = seq1.addGene(new AccessionID("gene1"), 1, 20, Strand.POSITIVE);
            gene1.addExon(new AccessionID("t1_1_10"), 1, 10);
            gene1.addExon(new AccessionID("t1_12_15"), 12, 15);
            GeneSequence gene2 = seq1.addGene(new AccessionID("gene2"), 1, 20, Strand.NEGATIVE);
            gene2.addExon(new AccessionID("t2_1_10"), 1, 10);
            gene2.addExon(new AccessionID("t2_12_15"), 12, 15);
            sequences.add(gene1);
            sequences.add(gene2);
            FastaGeneWriter fastaWriter = new FastaGeneWriter(System.out, sequences, new GenericFastaHeaderFormat<GeneSequence, NucleotideCompound>(), true);
            fastaWriter.process();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

