/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences;

import com.compomics.util.experiment.identification.psm_scoring.PsmScores;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class PsmScoringPreferences
implements Serializable {
    static final long serialVersionUID = 4997457408322410176L;
    private HashMap<Integer, HashSet<Integer>> spectrumMatchingScores = null;

    public void addScore(Integer advocateId, Integer scoreId) {
        HashSet<Integer> algorithmScores;
        if (this.spectrumMatchingScores == null) {
            this.spectrumMatchingScores = new HashMap();
        }
        if ((algorithmScores = this.spectrumMatchingScores.get(advocateId)) == null) {
            algorithmScores = new HashSet(1);
            this.spectrumMatchingScores.put(advocateId, algorithmScores);
        }
        algorithmScores.add(scoreId);
    }

    public HashSet<Integer> getScoreForAlgorithm(Integer advocateId) {
        if (this.spectrumMatchingScores == null) {
            return null;
        }
        return this.spectrumMatchingScores.get(advocateId);
    }

    public boolean isScoringNeeded(int advocate) {
        HashSet<Integer> scores;
        if (this.spectrumMatchingScores != null && !this.spectrumMatchingScores.isEmpty() && (scores = this.spectrumMatchingScores.get(advocate)) != null && !scores.isEmpty()) {
            for (int scoreIndex : scores) {
                if (scoreIndex == PsmScores.native_score.index) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isScoringNeeded(ArrayList<Integer> advocates) {
        if (this.spectrumMatchingScores != null && !this.spectrumMatchingScores.isEmpty()) {
            for (Integer advocate : advocates) {
                if (!this.isScoringNeeded(advocate)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTargetDecoyNeededForPsmScoring(ArrayList<Integer> advocates) {
        if (this.spectrumMatchingScores != null && !this.spectrumMatchingScores.isEmpty()) {
            for (Integer advocate : advocates) {
                HashSet<Integer> scores = this.spectrumMatchingScores.get(advocate);
                if (scores == null || scores.size() <= 1) continue;
                return true;
            }
        }
        return false;
    }
}

