/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences;

import com.compomics.util.experiment.identification.SearchParameters;
import com.compomics.util.preferences.AnnotationPreferences;
import com.compomics.util.preferences.GenePreferences;
import com.compomics.util.preferences.IdFilter;
import com.compomics.util.preferences.IdMatchValidationPreferences;
import com.compomics.util.preferences.PTMScoringPreferences;
import com.compomics.util.preferences.ProteinInferencePreferences;
import com.compomics.util.preferences.PsmScoringPreferences;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.io.Serializable;

public class IdentificationParameters
implements Serializable {
    static final long serialVersionUID = -5516259326385167746L;
    private SearchParameters searchParameters;
    private AnnotationPreferences annotationPreferences;
    private IdFilter idFilter = new IdFilter();
    private PsmScoringPreferences psmScoringPreferences;
    private PTMScoringPreferences ptmScoringPreferences = new PTMScoringPreferences();
    private SequenceMatchingPreferences sequenceMatchingPreferences;
    private GenePreferences genePreferences;
    private ProteinInferencePreferences proteinInferencePreferences;
    private IdMatchValidationPreferences idValidationPreferences = new IdMatchValidationPreferences();

    public SearchParameters getSearchParameters() {
        return this.searchParameters;
    }

    public void setSearchParameters(SearchParameters searchParameters) {
        this.searchParameters = searchParameters;
    }

    public AnnotationPreferences getAnnotationPreferences() {
        return this.annotationPreferences;
    }

    public void setAnnotationPreferences(AnnotationPreferences annotationPreferences) {
        this.annotationPreferences = annotationPreferences;
    }

    public IdFilter getIdFilter() {
        return this.idFilter;
    }

    public void setIdFilter(IdFilter idFilter) {
        this.idFilter = idFilter;
    }

    public PsmScoringPreferences getPsmScoringPreferences() {
        return this.psmScoringPreferences;
    }

    public void setPsmScoringPreferences(PsmScoringPreferences psmScoringPreferences) {
        this.psmScoringPreferences = psmScoringPreferences;
    }

    public PTMScoringPreferences getPtmScoringPreferences() {
        return this.ptmScoringPreferences;
    }

    public void setPtmScoringPreferences(PTMScoringPreferences ptmScoringPreferences) {
        this.ptmScoringPreferences = ptmScoringPreferences;
    }

    public SequenceMatchingPreferences getSequenceMatchingPreferences() {
        return this.sequenceMatchingPreferences;
    }

    public void setSequenceMatchingPreferences(SequenceMatchingPreferences sequenceMatchingPreferences) {
        this.sequenceMatchingPreferences = sequenceMatchingPreferences;
    }

    public IdMatchValidationPreferences getIdValidationPreferences() {
        return this.idValidationPreferences;
    }

    public void setIdValidationPreferences(IdMatchValidationPreferences idValidationPreferences) {
        this.idValidationPreferences = idValidationPreferences;
    }

    public ProteinInferencePreferences getProteinInferencePreferences() {
        return this.proteinInferencePreferences;
    }

    public void setProteinInferencePreferences(ProteinInferencePreferences proteinInferencePreferences) {
        this.proteinInferencePreferences = proteinInferencePreferences;
    }

    public GenePreferences getGenePreferences() {
        return this.genePreferences;
    }

    public void setGenePreferences(GenePreferences genePreferences) {
        this.genePreferences = genePreferences;
    }

    public static IdentificationParameters getDefaultIdentificationParameters() {
        return IdentificationParameters.getDefaultIdentificationParameters(null);
    }

    public static IdentificationParameters getDefaultIdentificationParameters(SearchParameters searchParameters) {
        IdentificationParameters identificationParameters = new IdentificationParameters();
        identificationParameters.setSearchParameters(searchParameters);
        AnnotationPreferences annotationPreferences = new AnnotationPreferences();
        if (searchParameters != null) {
            annotationPreferences.setPreferencesFromSearchParameters(searchParameters);
        }
        annotationPreferences.setAnnotationLevel(0.75);
        annotationPreferences.useAutomaticAnnotation(true);
        identificationParameters.setAnnotationPreferences(annotationPreferences);
        IdFilter idFilter = new IdFilter();
        if (searchParameters != null) {
            idFilter.setFilterFromSearchParameters(searchParameters);
        }
        identificationParameters.setIdFilter(idFilter);
        PsmScoringPreferences psmScoringPreferences = new PsmScoringPreferences();
        identificationParameters.setPsmScoringPreferences(psmScoringPreferences);
        PTMScoringPreferences ptmScoringPreferences = new PTMScoringPreferences();
        identificationParameters.setPtmScoringPreferences(ptmScoringPreferences);
        if (searchParameters != null) {
            SequenceMatchingPreferences sequenceMatchingPreferences = SequenceMatchingPreferences.getDefaultSequenceMatching(searchParameters);
            identificationParameters.setSequenceMatchingPreferences(sequenceMatchingPreferences);
        }
        GenePreferences genePreferences = new GenePreferences();
        identificationParameters.setGenePreferences(genePreferences);
        ProteinInferencePreferences proteinInferencePreferences = new ProteinInferencePreferences();
        if (searchParameters != null) {
            proteinInferencePreferences.setProteinSequenceDatabase(searchParameters.getFastaFile());
        }
        identificationParameters.setProteinInferencePreferences(proteinInferencePreferences);
        IdMatchValidationPreferences idValidationPreferences = new IdMatchValidationPreferences();
        identificationParameters.setIdValidationPreferences(idValidationPreferences);
        return identificationParameters;
    }

    public void setParametersFromSearch(SearchParameters searchParameters) {
        this.setSearchParameters(searchParameters);
        this.annotationPreferences = new AnnotationPreferences();
        if (searchParameters != null) {
            this.annotationPreferences.setPreferencesFromSearchParameters(searchParameters);
        }
        this.annotationPreferences.setAnnotationLevel(0.75);
        this.annotationPreferences.useAutomaticAnnotation(true);
        this.idFilter = new IdFilter();
        if (searchParameters != null) {
            this.idFilter.setFilterFromSearchParameters(searchParameters);
        }
        if (this.psmScoringPreferences == null) {
            this.psmScoringPreferences = new PsmScoringPreferences();
        }
        if (this.ptmScoringPreferences == null) {
            this.ptmScoringPreferences = new PTMScoringPreferences();
        }
        if (searchParameters != null) {
            this.sequenceMatchingPreferences = SequenceMatchingPreferences.getDefaultSequenceMatching(searchParameters);
        }
        if (this.genePreferences == null) {
            this.genePreferences = new GenePreferences();
        }
        if (this.proteinInferencePreferences == null) {
            this.proteinInferencePreferences = new ProteinInferencePreferences();
        }
        if (searchParameters != null) {
            this.proteinInferencePreferences.setProteinSequenceDatabase(searchParameters.getFastaFile());
        }
        if (this.idValidationPreferences == null) {
            this.idValidationPreferences = new IdMatchValidationPreferences();
        }
    }
}

