/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.spectrum;

import com.compomics.util.XYZDataPoint;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;

public class MassErrorBubblePlot
extends JPanel {
    private boolean useRelativeError = false;
    private static Color defaultMarkerColor = new Color(0, 0, 255, 25);
    private static Color bFragmentIonColor = new Color(0, 0, 255, 25);
    private static Color yFragmentIonColor = new Color(0, 255, 0, 25);
    private static Color otherFragmentIonColor = new Color(255, 0, 0, 25);
    public static final float DEFAULT_VISIBLE_MARKER_ALPHA = 1.0f;
    public static final float DEFAULT_NON_VISIBLE_MARKER_ALPHA = 0.0f;
    private ArrayList<IonMatch> currentlyUsedIonMatches;
    private ChartPanel chartPanel;
    private ArrayList<Color> dataSeriesfragmentIonColors = new ArrayList();

    public MassErrorBubblePlot(ArrayList<String> dataIndexes, ArrayList<ArrayList<IonMatch>> annotations, ArrayList<MSnSpectrum> currentSpectra, double massTolerance, boolean fragmentIonLabels, boolean addMarkers) {
        this(dataIndexes, annotations, currentSpectra, massTolerance, 1.0, fragmentIonLabels, addMarkers, false);
    }

    public MassErrorBubblePlot(ArrayList<String> dataIndexes, ArrayList<ArrayList<IonMatch>> annotations, ArrayList<MSnSpectrum> currentSpectra, double massTolerance, boolean fragmentIonLabels, boolean addMarkers, boolean useRelativeError) {
        this(dataIndexes, annotations, currentSpectra, massTolerance, 1.0, fragmentIonLabels, addMarkers, useRelativeError);
    }

    public MassErrorBubblePlot(ArrayList<String> dataIndexes, ArrayList<ArrayList<IonMatch>> annotations, ArrayList<MSnSpectrum> currentSpectra, double massTolerance, double bubbleScale, boolean fragmentIonLabels, boolean addMarkers, boolean useRelativeError) {
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 2));
        this.currentlyUsedIonMatches = new ArrayList();
        DefaultXYZDataset xyzDataset = new DefaultXYZDataset();
        HashMap<IonMatch, ArrayList<XYZDataPoint>> fragmentIonDataset = new HashMap<IonMatch, ArrayList<XYZDataPoint>>();
        double maxError = 0.0;
        for (int j = 0; j < annotations.size(); ++j) {
            ArrayList<IonMatch> currentAnnotations = annotations.get(j);
            MSnSpectrum currentSpectrum = currentSpectra.get(j);
            this.currentlyUsedIonMatches = currentAnnotations;
            if (this.currentlyUsedIonMatches.size() <= 0) continue;
            double maxAnnotatedIntensity = 0.0;
            for (int i = 0; i < this.currentlyUsedIonMatches.size(); ++i) {
                IonMatch ionMatch = this.currentlyUsedIonMatches.get(i);
                if (!(ionMatch.peak.intensity > maxAnnotatedIntensity)) continue;
                maxAnnotatedIntensity = ionMatch.peak.intensity;
            }
            double totalIntensity = currentSpectrum.getTotalIntensity();
            if (fragmentIonLabels) {
                for (int i = 0; i < this.currentlyUsedIonMatches.size(); ++i) {
                    IonMatch ionMatch = this.currentlyUsedIonMatches.get(i);
                    double error = useRelativeError ? ionMatch.getRelativeError() : ionMatch.getAbsoluteError();
                    if (Math.abs(error) > maxError) {
                        maxError = Math.abs(error);
                    }
                    if (fragmentIonDataset.get(ionMatch) != null) {
                        fragmentIonDataset.get(ionMatch).add(new XYZDataPoint(ionMatch.peak.mz, error, ionMatch.peak.intensity / totalIntensity * bubbleScale));
                        continue;
                    }
                    ArrayList<XYZDataPoint> temp = new ArrayList<XYZDataPoint>();
                    temp.add(new XYZDataPoint(ionMatch.peak.mz, error, ionMatch.peak.intensity / totalIntensity * bubbleScale));
                    fragmentIonDataset.put(ionMatch, temp);
                }
                xyzDataset = this.addXYZDataSeries(fragmentIonDataset);
                continue;
            }
            double[][] dataXYZ = new double[3][this.currentlyUsedIonMatches.size()];
            for (int i = 0; i < this.currentlyUsedIonMatches.size(); ++i) {
                IonMatch ionMatch = this.currentlyUsedIonMatches.get(i);
                double error = useRelativeError ? ionMatch.getRelativeError() : ionMatch.getAbsoluteError();
                if (Math.abs(error) > maxError) {
                    maxError = Math.abs(error);
                }
                dataXYZ[0][i] = ionMatch.peak.mz;
                dataXYZ[1][i] = error;
                dataXYZ[2][i] = ionMatch.peak.intensity / totalIntensity * bubbleScale;
                if (fragmentIonDataset.get(ionMatch) != null) {
                    fragmentIonDataset.get(ionMatch).add(new XYZDataPoint(ionMatch.peak.mz, error, ionMatch.peak.intensity / totalIntensity));
                    continue;
                }
                ArrayList<XYZDataPoint> temp = new ArrayList<XYZDataPoint>();
                temp.add(new XYZDataPoint(ionMatch.peak.mz, error, ionMatch.peak.intensity / totalIntensity));
                fragmentIonDataset.put(ionMatch, temp);
            }
            xyzDataset.addSeries((Comparable)((Object)dataIndexes.get(j)), dataXYZ);
        }
        String yAxisLabel = useRelativeError ? "m/z error (ppm)" : "m/z error (Da)";
        JFreeChart chart = ChartFactory.createBubbleChart(null, (String)"m/z", (String)yAxisLabel, (XYZDataset)xyzDataset, (PlotOrientation)PlotOrientation.VERTICAL, (!fragmentIonLabels ? 1 : 0) != 0, (boolean)true, (boolean)false);
        if (chart.getLegend() != null) {
            chart.getLegend().setPosition(RectangleEdge.RIGHT);
        }
        if (addMarkers) {
            MassErrorBubblePlot.addFragmentIonTypeMarkers(fragmentIonDataset, chart, true);
        }
        XYPlot plot = chart.getXYPlot();
        if (fragmentIonLabels) {
            for (int i = 0; i < xyzDataset.getSeriesCount(); ++i) {
                plot.getRenderer().setSeriesPaint(i, (Paint)this.dataSeriesfragmentIonColors.get(i));
            }
        }
        if (useRelativeError) {
            plot.getRangeAxis().setLowerBound(-maxError * 1.1);
            plot.getRangeAxis().setUpperBound(maxError * 1.1);
        } else {
            plot.getRangeAxis().setLowerBound(-massTolerance);
            plot.getRangeAxis().setUpperBound(massTolerance);
        }
        plot.getDomainAxis().setLowerBound(0.0);
        plot.getDomainAxis().setUpperBound(plot.getDomainAxis().getUpperBound() + 100.0);
        plot.getDomainAxis().setUpperMargin(0.0);
        plot.getDomainAxis().setLowerMargin(0.0);
        plot.setRangeGridlinePaint((Paint)Color.black);
        plot.setForegroundAlpha(0.5f);
        chart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        this.chartPanel = new ChartPanel(chart);
        this.chartPanel.setBackground(Color.WHITE);
        this.add((Component)this.chartPanel);
    }

    public static void addFragmentIonTypeMarkers(HashMap<IonMatch, ArrayList<XYZDataPoint>> data, JFreeChart chart, boolean showMarkers) {
        int horizontalFontPadding = 13;
        for (IonMatch fragmentIonType : data.keySet()) {
            ArrayList<XYZDataPoint> dataPoints = data.get(fragmentIonType);
            XYZDataPoint currentDataPoint = dataPoints.get(0);
            double currentXValue = currentDataPoint.getX();
            IntervalMarker intervalMarker = new IntervalMarker(currentXValue - 5.0, currentXValue + 5.0, (Paint)defaultMarkerColor);
            IonMatch ionMatch = fragmentIonType;
            String tempKey = ionMatch.getPeakAnnotation();
            intervalMarker.setLabel(tempKey);
            intervalMarker.setLabelFont(new Font("SansSerif", 0, 10));
            intervalMarker.setLabelPaint((Paint)Color.GRAY);
            intervalMarker.setLabelTextAnchor(TextAnchor.TOP_LEFT);
            if (tempKey.startsWith("b")) {
                intervalMarker.setPaint((Paint)bFragmentIonColor);
            } else if (tempKey.startsWith("y")) {
                intervalMarker.setPaint((Paint)yFragmentIonColor);
            } else {
                intervalMarker.setPaint((Paint)otherFragmentIonColor);
            }
            if (showMarkers) {
                intervalMarker.setAlpha(1.0f);
            } else {
                intervalMarker.setAlpha(0.0f);
            }
            if (tempKey.startsWith("y")) {
                intervalMarker.setLabelOffset(new RectangleInsets((double)horizontalFontPadding, 0.0, (double)horizontalFontPadding, 0.0));
            }
            if (tempKey.lastIndexOf("H2O") != -1) {
                intervalMarker.setLabelOffset(new RectangleInsets((double)(horizontalFontPadding * 2), 0.0, (double)(horizontalFontPadding * 2), 0.0));
            }
            if (tempKey.lastIndexOf("NH3") != -1) {
                intervalMarker.setLabelOffset(new RectangleInsets((double)(horizontalFontPadding * 3), 0.0, (double)(horizontalFontPadding * 3), 0.0));
            }
            if (tempKey.lastIndexOf("Prec") != -1) {
                intervalMarker.setLabelOffset(new RectangleInsets((double)(horizontalFontPadding * 4), 0.0, (double)(horizontalFontPadding * 4), 0.0));
                if (tempKey.lastIndexOf("H2O") != -1) {
                    intervalMarker.setLabelOffset(new RectangleInsets((double)(horizontalFontPadding * 5), 0.0, (double)(horizontalFontPadding * 5), 0.0));
                }
                if (tempKey.lastIndexOf("NH3") != -1) {
                    intervalMarker.setLabelOffset(new RectangleInsets((double)(horizontalFontPadding * 6), 0.0, (double)(horizontalFontPadding * 6), 0.0));
                }
            }
            if (tempKey.startsWith("i")) {
                intervalMarker.setLabelOffset(new RectangleInsets((double)(horizontalFontPadding * 5), 0.0, (double)(horizontalFontPadding * 5), 0.0));
            }
            if (tempKey.lastIndexOf("++") != -1) {
                intervalMarker.setLabelOffset(new RectangleInsets((double)(horizontalFontPadding * 7), 0.0, (double)(horizontalFontPadding * 7), 0.0));
                if (tempKey.lastIndexOf("H2O") != -1) {
                    intervalMarker.setLabelOffset(new RectangleInsets((double)(horizontalFontPadding * 8), 0.0, (double)(horizontalFontPadding * 8), 0.0));
                }
                if (tempKey.lastIndexOf("NH3") != -1) {
                    intervalMarker.setLabelOffset(new RectangleInsets((double)(horizontalFontPadding * 9), 0.0, (double)(horizontalFontPadding * 9), 0.0));
                }
            }
            ((XYPlot)chart.getPlot()).addDomainMarker((Marker)intervalMarker, Layer.BACKGROUND);
        }
    }

    public int getNumberOfDataPointsInPlot() {
        return this.currentlyUsedIonMatches.size();
    }

    public DefaultXYZDataset addXYZDataSeries(HashMap<IonMatch, ArrayList<XYZDataPoint>> data) {
        ArrayList<String> sortedKeys = new ArrayList<String>();
        HashMap<String, IonMatch> ionNameTypeMap = new HashMap<String, IonMatch>();
        for (IonMatch ionMatch : data.keySet()) {
            ionNameTypeMap.put(ionMatch.getPeakAnnotation(), ionMatch);
            sortedKeys.add(ionMatch.getPeakAnnotation());
        }
        Collections.sort(sortedKeys);
        DefaultXYZDataset dataset = new DefaultXYZDataset();
        for (int j = 0; j < sortedKeys.size(); ++j) {
            IonMatch ionMatch = (IonMatch)ionNameTypeMap.get(sortedKeys.get(j));
            ArrayList<XYZDataPoint> currentData = data.get(ionMatch);
            double[][] tempXYZData = new double[3][currentData.size()];
            for (int i = 0; i < currentData.size(); ++i) {
                tempXYZData[0][i] = currentData.get(i).getX();
                tempXYZData[1][i] = currentData.get(i).getY();
                tempXYZData[2][i] = currentData.get(i).getZ();
            }
            dataset.addSeries((Comparable)((Object)ionMatch.getPeakAnnotation()), tempXYZData);
            this.dataSeriesfragmentIonColors.add(SpectrumPanel.determineFragmentIonColor(ionMatch.ion, false));
        }
        return dataset;
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }
}

