/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.searchsettings.algorithm_settings;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.identification.identification_parameters.MsAmandaParameters;
import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class MsAmandaSettingsDialog
extends JDialog {
    private MsAmandaParameters msAmandaParameters;
    private boolean cancelled = false;
    private JPanel advancedSearchSettingsPanel;
    private JLabel advancedSettingsWarningLabel;
    private JPanel backgroundPanel;
    private JButton closeButton;
    private JComboBox decoyDatabaseCmb;
    private JLabel decoyDatabaseLabel;
    private JComboBox instrumentCmb;
    private JLabel instrumentLabel;
    private JLabel maxRankLabel;
    private JTextField maxRankTxt;
    private JComboBox monoIsotopicCmb;
    private JLabel monoIsotopicLabel;
    private JButton okButton;
    private JButton openDialogHelpJButton;

    public MsAmandaSettingsDialog(Frame parent, MsAmandaParameters msAmandaParameters) {
        super(parent, true);
        this.msAmandaParameters = msAmandaParameters;
        this.initComponents();
        this.setUpGUI();
        this.fillGUI();
        this.validateInput(false);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void setUpGUI() {
        this.decoyDatabaseCmb.setRenderer(new AlignedListCellRenderer(0));
        this.instrumentCmb.setRenderer(new AlignedListCellRenderer(0));
        this.monoIsotopicCmb.setRenderer(new AlignedListCellRenderer(0));
    }

    private void fillGUI() {
        if (this.msAmandaParameters.generateDecoy()) {
            this.decoyDatabaseCmb.setSelectedIndex(0);
        } else {
            this.decoyDatabaseCmb.setSelectedIndex(1);
        }
        this.instrumentCmb.setSelectedItem(this.msAmandaParameters.getInstrumentID());
        this.maxRankTxt.setText(this.msAmandaParameters.getMaxRank() + "");
        if (this.msAmandaParameters.isMonoIsotopic()) {
            this.monoIsotopicCmb.setSelectedIndex(0);
        } else {
            this.monoIsotopicCmb.setSelectedIndex(1);
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public MsAmandaParameters getInput() {
        MsAmandaParameters result = new MsAmandaParameters();
        result.setGenerateDecoyDatabase(this.decoyDatabaseCmb.getSelectedIndex() == 0);
        result.setInstrumentID((String)this.instrumentCmb.getSelectedItem());
        String input = this.maxRankTxt.getText().trim();
        if (!input.equals("")) {
            result.setMaxRank(new Integer(input));
        }
        result.setMonoIsotopic(this.monoIsotopicCmb.getSelectedIndex() == 0);
        return result;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.advancedSearchSettingsPanel = new JPanel();
        this.instrumentCmb = new JComboBox();
        this.decoyDatabaseCmb = new JComboBox();
        this.decoyDatabaseLabel = new JLabel();
        this.instrumentLabel = new JLabel();
        this.maxRankLabel = new JLabel();
        this.maxRankTxt = new JTextField();
        this.monoIsotopicLabel = new JLabel();
        this.monoIsotopicCmb = new JComboBox();
        this.okButton = new JButton();
        this.closeButton = new JButton();
        this.openDialogHelpJButton = new JButton();
        this.advancedSettingsWarningLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Advanced MS Amanda Settings");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.advancedSearchSettingsPanel.setBorder(BorderFactory.createTitledBorder("Search Settings"));
        this.advancedSearchSettingsPanel.setOpaque(false);
        this.instrumentCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"b, y", "b, y, -H2O, -NH3", "a, b, y, -H2O, -NH3, Imm", "a, b, y, -H2O, -NH3", "a, b, y", "a, b, y, Imm", "a, b, y, z, -H2O, -NH3, Imm", "c, y, z+1, z+2", "b, c, y, z+1, z+2", "b, y, INT", "b, y, INT, Imm", "a, b, y, INT", "a, b, y, INT, IMM", "a, b, y, INT, IMM, -H2O", "a, b, y, INT, IMM, -H2O, -NH3", "a, b, y, INT, IMM, -NH3"}));
        this.decoyDatabaseCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.decoyDatabaseCmb.setSelectedIndex(1);
        this.decoyDatabaseLabel.setText("Generate Decoy Database");
        this.instrumentLabel.setText("Fragment Ion Types");
        this.maxRankLabel.setText("Max Rank");
        this.maxRankTxt.setHorizontalAlignment(0);
        this.maxRankTxt.setText("1");
        this.maxRankTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MsAmandaSettingsDialog.this.maxRankTxtKeyReleased(evt);
            }
        });
        this.monoIsotopicLabel.setText("Monoisotopic");
        this.monoIsotopicCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        GroupLayout advancedSearchSettingsPanelLayout = new GroupLayout(this.advancedSearchSettingsPanel);
        this.advancedSearchSettingsPanel.setLayout(advancedSearchSettingsPanelLayout);
        advancedSearchSettingsPanelLayout.setHorizontalGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.instrumentLabel, -2, 200, -2).addComponent(this.decoyDatabaseLabel, -2, 200, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.instrumentCmb, 0, 189, Short.MAX_VALUE).addComponent(this.decoyDatabaseCmb, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE))).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.maxRankLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxRankTxt)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.monoIsotopicLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.monoIsotopicCmb, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        advancedSearchSettingsPanelLayout.setVerticalGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.decoyDatabaseLabel).addComponent(this.decoyDatabaseCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.instrumentCmb, -2, -1, -2).addComponent(this.instrumentLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.monoIsotopicLabel).addComponent(this.monoIsotopicCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxRankLabel).addComponent(this.maxRankTxt, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MsAmandaSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MsAmandaSettingsDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Help");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                MsAmandaSettingsDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                MsAmandaSettingsDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MsAmandaSettingsDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        this.advancedSettingsWarningLabel.setText("Click to open the MS Amanda help page.");
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.advancedSearchSettingsPanel, -1, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.openDialogHelpJButton).addGap(18, 18, 18).addComponent(this.advancedSettingsWarningLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.advancedSearchSettingsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.openDialogHelpJButton).addComponent(this.advancedSettingsWarningLabel).addComponent(this.okButton).addComponent(this.closeButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput(true)) {
            this.dispose();
        }
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://ms.imp.ac.at/?goto=msamanda");
        this.setCursor(new Cursor(0));
    }

    private void maxRankTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    public boolean validateInput(boolean showMessage) {
        boolean valid = true;
        valid = GuiUtilities.validateIntegerInput(this, this.maxRankLabel, this.maxRankTxt, "number of spectrum matches", "Number Spectrum Matches Error", true, showMessage, valid);
        this.okButton.setEnabled(valid);
        return valid;
    }
}

