/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.util.mascot;

import com.compomics.mascotdatfile.util.mascot.ProteinID;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ProteinMap {
    private static Logger logger = Logger.getLogger(ProteinMap.class);
    private int iNumberOfProteins;
    private HashMap iProteinMap = new HashMap();

    public ProteinMap(HashMap aProteinSection) {
        if (aProteinSection != null) {
            this.iNumberOfProteins = aProteinSection.size();
            this.buildProteinMap(aProteinSection);
        }
    }

    private void buildProteinMap(HashMap aProteinSection) {
        this.iProteinMap = new HashMap(this.iNumberOfProteins);
        Iterator iter = aProteinSection.keySet().iterator();
        Object st = null;
        ProteinID lProteinID = null;
        while (iter.hasNext()) {
            String lNext = (String)iter.next();
            if (lNext == null || lNext.contains("_tax")) continue;
            String lAccession = lNext;
            String lProteinValue = (String)aProteinSection.get(lAccession);
            Pattern pattern = Pattern.compile("[\"]?([^\"]+)[\"]?");
            Matcher m = pattern.matcher(lAccession);
            if (m.find()) {
                lAccession = m.group(1);
            }
            double lMass = Double.parseDouble(lProteinValue.substring(0, lProteinValue.indexOf(",", 0)));
            String lDescription = lProteinValue.substring(lProteinValue.indexOf("\"") + 1, lProteinValue.length() - 1);
            lProteinID = new ProteinID(lAccession, lMass, lDescription);
            this.iProteinMap.put(lAccession, lProteinID);
        }
    }

    public void addProteinSource(String aAccession, int aQueryNumber, int aPeptideHitNumber) {
        ProteinID lProteinID;
        if (this.iProteinMap.get(aAccession) == null) {
            double lMass = -1.0;
            String lDescription = "no description";
            lProteinID = new ProteinID(aAccession, lMass, lDescription);
            this.iProteinMap.put(aAccession, lProteinID);
        }
        lProteinID = (ProteinID)this.iProteinMap.get(aAccession);
        lProteinID.addSource(aQueryNumber, aPeptideHitNumber);
    }

    public ProteinID getProteinID(String aAccession) {
        ProteinID lProteinID = null;
        lProteinID = this.iProteinMap.get(aAccession) == null ? new ProteinID(aAccession, -1.0, "No Description.") : (ProteinID)this.iProteinMap.get(aAccession);
        return lProteinID;
    }

    public String getProteinDescription(String aAccession) {
        String result = null;
        result = this.iProteinMap.get(aAccession) != null ? ((ProteinID)this.iProteinMap.get(aAccession)).getDescription() : "No Description.";
        return result;
    }

    public int getNumberOfProteins() {
        return this.iNumberOfProteins;
    }

    public Iterator getProteinIDIterator() {
        return this.iProteinMap.keySet().iterator();
    }
}

