/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.util.mascot;

import com.compomics.mascotdatfile.util.exception.MascotDatfileException;
import com.compomics.mascotdatfile.util.interfaces.Modification;
import com.compomics.mascotdatfile.util.mascot.ErrorTolerantModification;
import com.compomics.mascotdatfile.util.mascot.FixedModification;
import com.compomics.mascotdatfile.util.mascot.Masses;
import com.compomics.mascotdatfile.util.mascot.ModificationConversion;
import com.compomics.mascotdatfile.util.mascot.ModificationList;
import com.compomics.mascotdatfile.util.mascot.Parameters;
import com.compomics.mascotdatfile.util.mascot.PeptideHitAnnotation;
import com.compomics.mascotdatfile.util.mascot.ProteinHit;
import com.compomics.mascotdatfile.util.mascot.ProteinMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class PeptideHit
implements Serializable {
    private static Logger logger = Logger.getLogger(PeptideHit.class);
    public static final Integer MISSED_CLEAVAGES = new Integer(1);
    public static final Integer PEPTIDE_MASS = new Integer(2);
    public static final Integer DELTA_MASS = new Integer(3);
    public static final Integer NUMBER_OF_IONS_MATCHED = new Integer(4);
    public static final Integer SEQUENCE = new Integer(5);
    public static final Integer MODIFIED_SEQUENCE = new Integer(6);
    public static final Integer PEAKS_USED_FROM_IONS = new Integer(7);
    public static final Integer IONS_SCORE = new Integer(8);
    public static final Integer THRESHOLD = new Integer(9);
    private String iPeptideHit_pep = null;
    private String iPeptideHit_prot = null;
    private int iMissedCleavages = 0;
    private double iPeptideMr = 0.0;
    private double iDeltaMass = 0.0;
    private int iNumberOfIonsMatched = 0;
    private String iSequence = null;
    private int iPeaksUsedFromIons1 = 0;
    private int[] iVariableModificationsArray = null;
    private double iIonsScore = 0.0;
    private int[] iIonSeriesFound = null;
    private int iPeaksUsedFromIons2 = 0;
    private int iPeaksUsedFromIons3 = 0;
    private ArrayList iProteinHits = new ArrayList(1);
    private Modification[] iModifications = null;
    private String iModifiedSequence = null;
    private String[] iModifiedSequenceComponents = null;
    private double iQueryIdentityThreshold = 0.0;
    private double iHomologyThreshold = 0.0;
    private PeptideHitAnnotation iPha = null;
    private boolean boolErrorTolerantHit = false;
    private boolean debug = false;

    private PeptideHit(String aPeptideHit, ProteinMap aProteinMap, ModificationList aModificationList, double[] aThreshold) {
        this(aPeptideHit, aProteinMap, aModificationList, aThreshold, null);
    }

    private PeptideHit(String aPeptideHit, ProteinMap aProteinMap, ModificationList aModificationList, double[] aThreshold, String substitutions) {
        this.splitPeptideHit(aPeptideHit);
        this.parseDatFilePeptideString();
        if (substitutions != null) {
            this.substitutePeptides(substitutions);
        }
        this.parseDatFileProteinString();
        this.parseThresholds(aThreshold);
        this.parsePeptideHitModifications(aModificationList);
    }

    private void substitutePeptides(String substitutions) {
        String[] substitutionArray = substitutions.split(",");
        StringBuilder replaceAminoAcids = new StringBuilder(this.iSequence);
        replaceAminoAcids.setCharAt(Integer.parseInt(substitutionArray[0]) - 1, substitutionArray[2].charAt(0));
        this.iSequence = replaceAminoAcids.toString();
    }

    public PeptideHit(String aETSPeptideHitString, String aETSPeptideHitMods, ProteinMap aProteinMap, ModificationList aModificationList, double[] aThreshold) {
        this.splitPeptideHit(aETSPeptideHitString);
        this.parseDatFilePeptideString();
        this.parseDatFileProteinString();
        this.parseThresholds(aThreshold);
        this.parsePeptideHitModifications(aModificationList, aETSPeptideHitMods);
        this.setErrorTolerantHit(true);
    }

    public static PeptideHit parsePeptideHit(String aPeptideHit, ProteinMap aProteinMap, ModificationList aModificationList, double[] aThreshold) {
        PeptideHit ph = null;
        if (!aPeptideHit.equals("-1")) {
            ph = new PeptideHit(aPeptideHit, aProteinMap, aModificationList, aThreshold);
        }
        return ph;
    }

    public static PeptideHit parsePeptideHit(String aPeptideHit, ProteinMap aProteinMap, ModificationList aModificationList, double[] aThreshold, String substitution) {
        PeptideHit ph = null;
        if (!aPeptideHit.equals("-1")) {
            ph = new PeptideHit(aPeptideHit, aProteinMap, aModificationList, aThreshold, substitution);
        }
        return ph;
    }

    public static PeptideHit parsePeptideHit(String aETSPeptideHitString, String aETSPeptideHitMods, ProteinMap aProteinMap, ModificationList aModificationList, double[] aThreshold) {
        PeptideHit ph = null;
        if (!aETSPeptideHitString.equals("-1")) {
            ph = new PeptideHit(aETSPeptideHitString, aETSPeptideHitMods, aProteinMap, aModificationList, aThreshold);
        }
        return ph;
    }

    private void splitPeptideHit(String aPeptideHit) {
        StringTokenizer st = new StringTokenizer(aPeptideHit, ";");
        if (st.countTokens() != 2 && this.debug) {
            System.out.println("Warning, more than two ';' semicolons used in the peptidehit String!!\t" + aPeptideHit);
        }
        int lSplitIndex = aPeptideHit.indexOf(59);
        this.iPeptideHit_pep = aPeptideHit.substring(0, lSplitIndex);
        this.iPeptideHit_prot = aPeptideHit.substring(lSplitIndex + 1);
    }

    private void parseDatFilePeptideString() {
        StringTokenizer st = new StringTokenizer(this.iPeptideHit_pep, ",");
        if (st.countTokens() != 11) {
            throw new MascotDatfileException("Wrong String with input data to set variable values (found " + st.countTokens() + " tokens instead of expected 11).");
        }
        this.setMissedCleavages(Integer.parseInt(st.nextToken()));
        this.setPeptideMr(Double.parseDouble(st.nextToken()));
        this.setDeltaMass(Double.parseDouble(st.nextToken()));
        this.setNumberOfIonsMatched(Integer.parseInt(st.nextToken()));
        this.setSequence(st.nextToken());
        this.setPeaksUsedFromIons1(Integer.parseInt(st.nextToken()));
        this.setVariableModificationsArray(st.nextToken());
        this.setIonsScore(Double.parseDouble(st.nextToken()));
        this.parseIonSeries(st.nextToken());
        this.setPeaksUsedFromIons2(Integer.parseInt(st.nextToken()));
        this.setPeaksUsedFromIons3(Integer.parseInt(st.nextToken()));
    }

    private void parseThresholds(double[] aThreshold) {
        this.iHomologyThreshold = aThreshold[0];
        this.iQueryIdentityThreshold = aThreshold[1];
    }

    private void parseDatFileProteinString() {
        if (this.iPeptideHit_prot.indexOf(",") == -1) {
            this.iProteinHits.add(new ProteinHit(this.iPeptideHit_prot));
        } else {
            String[] proArr = this.iPeptideHit_prot.split(",\"");
            for (int i = 0; i < proArr.length; ++i) {
                if (i == 0) {
                    this.iProteinHits.add(new ProteinHit(proArr[i]));
                    continue;
                }
                this.iProteinHits.add(new ProteinHit("\"" + proArr[i]));
            }
        }
    }

    public int getMissedCleavages() {
        return this.iMissedCleavages;
    }

    public void setMissedCleavages(int aMissedCleavages) {
        this.iMissedCleavages = aMissedCleavages;
    }

    public double getPeptideMr() {
        return this.iPeptideMr;
    }

    public void setPeptideMr(double aPeptideMr) {
        this.iPeptideMr = aPeptideMr;
    }

    public double getDeltaMass() {
        return this.iDeltaMass;
    }

    public void setDeltaMass(double aDeltaMass) {
        this.iDeltaMass = aDeltaMass;
    }

    public void setErrorTolerantHit(boolean aErrorTolerantHit) {
        this.boolErrorTolerantHit = aErrorTolerantHit;
    }

    public int getNumberOfIonsMatched() {
        return this.iNumberOfIonsMatched;
    }

    public void setNumberOfIonsMatched(int aNumberOfIonsMatched) {
        this.iNumberOfIonsMatched = aNumberOfIonsMatched;
    }

    public String getSequence() {
        return this.iSequence;
    }

    public void setSequence(String aSequence) {
        this.iSequence = aSequence;
    }

    public int getPeaksUsedFromIons1() {
        return this.iPeaksUsedFromIons1;
    }

    public void setPeaksUsedFromIons1(int aPeaksUsedFromIons1) {
        this.iPeaksUsedFromIons1 = aPeaksUsedFromIons1;
    }

    public boolean isErrorTolerantHit() {
        return this.boolErrorTolerantHit;
    }

    public int[] getVariableModificationsArray() {
        return this.iVariableModificationsArray;
    }

    public void setVariableModificationsArray(int[] aVariableModificationsArray) {
        this.iVariableModificationsArray = aVariableModificationsArray;
    }

    public void setVariableModificationsArray(String aVariableModificationString) {
        this.iVariableModificationsArray = new int[aVariableModificationString.length()];
        for (int i = 0; i < aVariableModificationString.length(); ++i) {
            char c = aVariableModificationString.charAt(i);
            this.iVariableModificationsArray[i] = c != 'X' ? Integer.parseInt("" + c, 16) : (int)c;
        }
    }

    public double getIonsScore() {
        return this.iIonsScore;
    }

    public void setIonsScore(double aIonsScore) {
        this.iIonsScore = aIonsScore;
    }

    public int[] getIonSeriesFound() {
        return this.iIonSeriesFound;
    }

    public void setIonSeriesFound(int[] aIonSeriesFound) {
        this.iIonSeriesFound = aIonSeriesFound;
    }

    public int getPeaksUsedFromIons2() {
        return this.iPeaksUsedFromIons2;
    }

    public void setPeaksUsedFromIons2(int aPeaksUsedFromIons2) {
        this.iPeaksUsedFromIons2 = aPeaksUsedFromIons2;
    }

    public int getPeaksUsedFromIons3() {
        return this.iPeaksUsedFromIons3;
    }

    public void setPeaksUsedFromIons3(int aPeaksUsedFromIons3) {
        this.iPeaksUsedFromIons3 = aPeaksUsedFromIons3;
    }

    public ArrayList getProteinHits() {
        return this.iProteinHits;
    }

    public void setProteinHits(ArrayList aProteinHits) {
        this.iProteinHits = aProteinHits;
    }

    public int getNumberOfAminoAcid(char aAminoAcid) {
        int lCount = 0;
        for (int i = 0; i < this.iSequence.length(); ++i) {
            if (this.iSequence.charAt(i) != aAminoAcid) continue;
            ++lCount;
        }
        return lCount;
    }

    public void parsePeptideHitModifications(ModificationList aMod, String aETSMod) {
        this.parsePeptideHitModifications(aMod);
        for (int i = 0; i < this.iVariableModificationsArray.length; ++i) {
            if (this.iVariableModificationsArray[i] != 88) continue;
            double lMass = -1.0;
            double lNeutralLoss = -1.0;
            String lType = null;
            String lShortType = null;
            String lLocation = null;
            StringTokenizer st = new StringTokenizer(aETSMod, ",");
            int lCounter = -1;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (++lCounter == 0) {
                    lMass = Double.parseDouble(token);
                    continue;
                }
                if (lCounter == 1) {
                    lNeutralLoss = Double.parseDouble(token);
                    continue;
                }
                if (lCounter != 2) continue;
                int indexStart = 0;
                int indexStop = token.indexOf(40) - 1;
                lType = token.substring(indexStart, indexStop);
                lShortType = (String)ModificationConversion.getInstance().getConversionMap().get(token);
                lShortType = lShortType == null ? "ETS_" + lType : "**" + lShortType;
                lType = "ETS_" + lType;
                indexStart = token.indexOf(40) + 1;
                indexStop = token.indexOf(41);
                lLocation = token.substring(indexStart, indexStop);
            }
            this.iModifications[i] = new ErrorTolerantModification(lType, lShortType, lMass, lNeutralLoss, lLocation, 88);
        }
    }

    public void parsePeptideHitModifications(ModificationList aMod) {
        char c;
        int index;
        int i;
        this.iModifications = new Modification[this.iSequence.length() + 2];
        FixedModification lTempF = null;
        Object lTempV = null;
        for (i = 0; i < aMod.getFixedModifications().size(); ++i) {
            lTempF = null;
            lTempF = (FixedModification)aMod.getFixedModifications().get(i);
            if (!lTempF.getLocation().startsWith("N_term")) continue;
            if (lTempF.getLocation().length() == 6) {
                this.iModifications[0] = lTempF;
                continue;
            }
            index = lTempF.getLocation().length();
            c = lTempF.getLocation().charAt(index - 1);
            if (this.iSequence.charAt(0) != c) continue;
            this.iModifications[0] = lTempF;
        }
        for (i = 0; i < aMod.getFixedModifications().size(); ++i) {
            lTempF = null;
            lTempF = (FixedModification)aMod.getFixedModifications().get(i);
            if (!lTempF.getLocation().startsWith("C_term")) continue;
            if (lTempF.getLocation().length() == 6) {
                this.iModifications[this.iSequence.length() + 1] = lTempF;
                continue;
            }
            index = lTempF.getLocation().length();
            c = lTempF.getLocation().charAt(index - 1);
        }
        for (i = 0; i < this.iSequence.length(); ++i) {
            char lAminoAcid = this.iSequence.charAt(i);
            for (int j = 0; j < aMod.getFixedModifications().size(); ++j) {
                lTempF = null;
                lTempF = (FixedModification)aMod.getFixedModifications().get(j);
                if (lTempF.getLocation().indexOf(95) != -1) continue;
                char[] lModLocation = lTempF.getLocation().toCharArray();
                for (int k = 0; k < lModLocation.length; ++k) {
                    if (lModLocation[k] != lAminoAcid) continue;
                    this.iModifications[i + 1] = lTempF;
                }
            }
        }
        for (i = 0; i < this.iSequence.length() + 2; ++i) {
            if (this.iVariableModificationsArray[i] == 0) continue;
            this.iModifications[i] = aMod.getVariableModificationByModificationID(this.iVariableModificationsArray[i]);
        }
    }

    public Modification[] getModifications() {
        return this.iModifications;
    }

    public String getModifiedSequence() {
        if (this.iModifiedSequence == null) {
            if (this.iModifiedSequenceComponents == null) {
                this.getModifiedSequenceComponents();
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.iModifiedSequenceComponents.length; ++i) {
                String lModifiedSequenceComponent = this.iModifiedSequenceComponents[i];
                sb.append(lModifiedSequenceComponent);
            }
            this.iModifiedSequence = sb.toString();
        }
        return this.iModifiedSequence;
    }

    public String[] getModifiedSequenceComponents() {
        if (this.iModifiedSequenceComponents == null) {
            this.iModifiedSequenceComponents = new String[this.iSequence.length()];
            StringBuffer sb = new StringBuffer();
            boolean pyro = false;
            if (this.iModifications[0] != null && this.iModifications[0].getShortType().indexOf("Py") != 0) {
                sb.append(this.iModifications[0].getShortType());
                if (this.iModifications[0].isFixed()) {
                    sb.append("*");
                }
            } else if (this.iModifications[0] != null && this.iModifications[0].getShortType().indexOf("Py") == 0) {
                pyro = true;
                sb.append("NH2");
            } else {
                sb.append("NH2");
            }
            sb.append("-");
            for (int i = 0; i < this.iSequence.length(); ++i) {
                sb.append(this.iSequence.charAt(i));
                if (i == 0 && pyro) {
                    StringBuffer sbPyr = new StringBuffer("<" + this.iModifications[0].getShortType());
                    if (this.iModifications[0].isFixed()) {
                        sbPyr.append("*");
                    }
                    if (this.iModifications[i + 1] != null) {
                        sbPyr.append("," + this.iModifications[i + 1].getShortType());
                        if (this.iModifications[i + 1].isFixed()) {
                            sbPyr.append("*");
                        }
                    }
                    sbPyr.append(">");
                    sb.append(sbPyr);
                } else if (this.iModifications[i + 1] != null) {
                    sb.append("<" + this.iModifications[i + 1].getShortType());
                    if (this.iModifications[i + 1].isFixed()) {
                        sb.append("*");
                    }
                    sb.append(">");
                }
                if (i >= this.iSequence.length() - 1) continue;
                this.iModifiedSequenceComponents[i] = sb.toString();
                sb.delete(0, sb.length());
            }
            sb.append("-");
            if (this.iModifications[this.iSequence.length() + 1] != null) {
                sb.append(this.iModifications[this.iSequence.length() + 1].getShortType());
                if (this.iModifications[this.iSequence.length() + 1].isFixed()) {
                    sb.append("*");
                }
            } else {
                sb.append("COOH");
            }
            this.iModifiedSequenceComponents[this.iModifiedSequenceComponents.length - 1] = sb.toString();
        }
        return this.iModifiedSequenceComponents;
    }

    public boolean scoresAboveHomologyThreshold() {
        return this.iIonsScore >= this.iHomologyThreshold;
    }

    public boolean scoresAboveIdentityThreshold() {
        return this.scoresAboveIdentityThreshold(0.05);
    }

    public boolean scoresAboveIdentityThreshold(double aConfidenceInterval) {
        double lThreshold = this.calculateIdentityThreshold(aConfidenceInterval);
        return this.iIonsScore >= lThreshold;
    }

    public boolean scoresAboveIdentityThreshold(int aDelta) {
        return this.scoresAboveIdentityThreshold(0.05, aDelta);
    }

    public boolean scoresAboveIdentityThreshold(double aConfidenceInterval, int aDelta) {
        double lThreshold = this.calculateIdentityThreshold(aConfidenceInterval);
        return this.iIonsScore >= lThreshold + (double)aDelta;
    }

    public double getExpectancy() {
        return this.getExpectancy(0.05);
    }

    public double getHomologyThreshold() {
        return this.iHomologyThreshold;
    }

    public double getExpectancy(double aConfidenceInterval) {
        double lThreshold = this.calculateIdentityThreshold(aConfidenceInterval);
        return aConfidenceInterval * Math.pow(10.0, (lThreshold - this.iIonsScore) / 10.0);
    }

    public double calculateIdentityThreshold() {
        return this.calculateIdentityThreshold(0.05);
    }

    public double calculateIdentityThreshold(double aConfidenceInterval) {
        return 10.0 * Math.log(this.iQueryIdentityThreshold / (aConfidenceInterval * 20.0)) / Math.log(10.0);
    }

    private void parseIonSeries(String aIonSeries) {
        this.iIonSeriesFound = new int[aIonSeries.length()];
        for (int i = 0; i < aIonSeries.length(); ++i) {
            this.iIonSeriesFound[i] = Character.getNumericValue(aIonSeries.charAt(i));
        }
    }

    public PeptideHitAnnotation getPeptideHitAnnotation(Masses aMasses, Parameters aParameters, double aPrecursorMZ, String aPrecursorCharge) {
        if (this.iPha == null) {
            this.iPha = new PeptideHitAnnotation(this.iSequence, this.iModifications, aMasses, aParameters, this.iIonSeriesFound, aPrecursorMZ, aPrecursorCharge);
        }
        return this.iPha;
    }

    public PeptideHitAnnotation getPeptideHitAnnotation(Masses aMasses, Parameters aParameters) {
        if (this.iPha == null) {
            this.iPha = new PeptideHitAnnotation(this.iSequence, this.iModifications, aMasses, aParameters, this.iIonSeriesFound);
        }
        return this.iPha;
    }

    public String toString() {
        return this.getModifiedSequence() + " - " + this.iIonsScore;
    }
}

