## ----options, eval=TRUE, echo=FALSE-------------------------------------------
options(showHeadLines=3)
options(showTailLines=3)

## ----getPackage, eval=FALSE---------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("GDSArray")

## ----Load, message=FALSE------------------------------------------------------
library(GDSArray)

## ---- GDSArray----------------------------------------------------------------
file <- SeqArray::seqExampleFileName("gds")
#> GDSArray(file, "genotype")  #> deactivate temporarily 3/4/20

## ---- GDSMatrix---------------------------------------------------------------
GDSArray(file, "annotation/format/DP")

## ---- GDSFile-----------------------------------------------------------------
gf <- GDSFile(file)
gf$annotation$info
gf$annotation$info$AC

## ---- seedAccessor------------------------------------------------------------
#> ga <- GDSArray(file, "genotype")  #> deactivate temporarily 3/4/20
#> seed(ga)

## ---- gdsfileAccessor---------------------------------------------------------
#> gdsfile(ga)

## ---- gdsnodes----------------------------------------------------------------
gdsnodes(file)
identical(gdsnodes(file), gdsnodes(gf))
GDSArray(file, name=gdsnodes(file)[2])

## ---- dims--------------------------------------------------------------------
ga <- GDSArray(file, "annotation/format/DP")
dim(ga)
class(dimnames(ga))
lengths(dimnames(ga))

## ---- methods-----------------------------------------------------------------
ga[1:3, 10:15]
ga[c(TRUE, FALSE), ]

## ---- numeric-----------------------------------------------------------------
dp <- GDSArray(file, "annotation/format/DP")
dp
log(dp)

dp[rowMeans(dp) < 60, ]

## ---- GDSArraySeed------------------------------------------------------------
#> seed <- GDSArray:::GDSArraySeed(file, "genotype")  #> deactivate temporarily 3/4/20
#> seed

## ---- GDSArray-from-GDSArraySeed----------------------------------------------
#> GDSArray(seed)

## ---- da----------------------------------------------------------------------
#> class(DelayedArray(seed))

## ---- sessionInfo-------------------------------------------------------------
sessionInfo()

