## ----libraryLoad, message=FALSE, warning=FALSE--------------------------------
library(ENCODExplorer)

## ----load_encodeDF, collapse=TRUE---------------------------------------------
encode_df <- get_encode_df()

## ----query_results, collapse=TRUE, eval =T------------------------------------
query_results <- queryEncode(organism = "Homo sapiens", 
                      biosample_name = "MCF-7", file_format = "fastq",
                      fixed = TRUE)

## ----query_results_2, collapse=TRUE-------------------------------------------
query_results <- queryEncode(organism = "Homo sapiens", biosample_name = "mcf7",
                        file_format = "fastq", fixed = TRUE,
                        fuzzy = FALSE)

## ----query_results_3, collapse=TRUE-------------------------------------------
query_results <- queryEncode(organism = "Homo sapiens",
                    biosample_name = "mcf7", file_format = "fastq",
                    fixed = TRUE, fuzzy = TRUE)

## ----query_results_4, collapse=TRUE-------------------------------------------
query_results <- queryEncode(assay = ".*RNA-seq",
                    biosample_name = "HeLa-S3", fixed = FALSE)
table(query_results$assay)

## ----query_results_5, collapse=TRUE-------------------------------------------
query_results <- queryEncodeGeneric(biosample_name="HeLa-S3",
				    assay="RNA-seq", submitted_by="Diane Trout",
				    fuzzy=TRUE)
table(query_results$submitted_by)

## ----fuzzy_results, collapse=TRUE---------------------------------------------
fuzzy_results <- fuzzySearch(searchTerm = c("brca"))

## ----fuzzy_results_2, collapse=TRUE-------------------------------------------
fuzzy_results <- fuzzySearch(searchTerm = c("brca", "ZNF24"),
                             filterVector = c("target"),
                             multipleTerm = TRUE)

## ----search_results, collapse=TRUE--------------------------------------------
  search_results <- searchEncode(searchTerm = "a549 chip-seq homo sapiens",
                                 limit = "all")

## ----query_results_6, collapse=TRUE-------------------------------------------
query_results <- queryEncode(assay = "switchgear", target ="elavl1", fixed = FALSE)

## ----search_results_1, collapse=TRUE------------------------------------------
search_results <- searchEncode(searchTerm = "switchgear elavl1", limit = "all")

## ----query_results_7, collapse=TRUE, eval=FALSE-------------------------------
#  query_results <- queryEncode(assay = "switchgear", target ="elavl1",
#                               file_format = "bed" , fixed = FALSE)
#  downloadEncode(query_results)

## ----collapse=TRUE, eval=FALSE------------------------------------------------
#  downloadEncode(search_results, format = "bed")

## ----search_results_2, collapse=TRUE------------------------------------------
search_results <- searchEncode(searchTerm = "switchgear elavl1", limit = "all")

## ----convert_results_1, collapse=TRUE-----------------------------------------
convert_results <- searchToquery(searchResults = search_results)

## ----query_consensus_peaks_call, collapse=TRUE--------------------------------
# Obtain a summary of all peaks for CTCF ChIP-Seq assays in the 22Rv1
# (human prostate carcinoma) cell line.
res = queryConsensusPeaks("22Rv1", "GRCh38", "CTCF")

## ----query_consensus_peaks_files, collapse=TRUE-------------------------------
files(res)

## ----query_consensus_peaks_file_metadata, collapse=TRUE-----------------------
f_meta = file_metadata(res)
names(f_meta)
f_meta[[1]][,1:5]

## ----query_consensus_peaks_metadata, collapse=TRUE----------------------------
metadata(res)

## ----query_consensus_peaks_peaks, collapse=TRUE-------------------------------
names(peaks(res))
names(peaks(res)[[1]])
peaks(res)[[1]]

## ----query_consensus_peaks_consensus, collapse=TRUE---------------------------
names(consensus(res))
consensus(res)

## ----build_consensus_peaks_call, collapse=TRUE--------------------------------
query_results = queryEncodeGeneric(biosample_name="A549", assembly="GRCh38",
                                   file_format="^bed$", output_type="^peaks$", 
                                   treatment_duration_unit="minute",
                                   treatment_duration="(^5$|^10$)", 
                                   target="NR3C1", fixed=FALSE)

# Obtain a summary of all peaks for NR3C1 ChIP-Seq assays in the A549
# cell line.
res = buildConsensusPeaks(query_results, split_by=c("treatment_duration"), 
                          consensus_threshold=0.5)

res

## ----query_gene_expression, collapse=TRUE-------------------------------------
# Obtain a summary of all peaks for NR3C1 ChIP-Seq assays in the A549
# cell line.
res = queryGeneExpression("bone marrow")

## ----query_gene_expression_metadata, collapse=TRUE----------------------------
metadata(res)

## ----query_gene_expression_metric, collapse=TRUE------------------------------
metric(res)

## ----query_gene_expression_metric_data, collapse=TRUE-------------------------
head(metric_data(res))

## ----query_gene_expression_raw_data, collapse=TRUE----------------------------
head(raw_data(res)[[1]][[1]])

## ----build_expression_summary, collapse=TRUE----------------------------------
query_results = queryEncodeGeneric(biosample_name="neural tube", 
                                   output_type="gene quantifications",
                                   file_type="tsv",
                                   assay="polyA plus RNA-seq",
                                   assembly="^mm10$",
                                   dataset_biosample_summary="(15.5|13.5)",
                                   fixed=FALSE)
                                   
buildExpressionSummary(query_results, split_by="dataset_biosample_summary")                                   

## ----query_expression_interactive, eval=FALSE---------------------------------
#  queryGeneExpression("neural tube", use_interactive=TRUE)

## ----ah, message=FALSE--------------------------------------------------------
require(AnnotationHub)
ah = AnnotationHub()
query(ah, "ENCODExplorerData")

