/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private RenderedImage myImage;

    public ImagePanel() {
        this.setOpaque(true);
    }

    public void setImage(RenderedImage renderedImage) {
        this.myImage = renderedImage;
        this.repaint();
    }

    public RenderedImage getImage() {
        return this.myImage;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.myImage == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        double d = dimension.getWidth() - (double)insets.left - (double)insets.right;
        double d2 = dimension.getHeight() - (double)insets.top - (double)insets.bottom;
        double d3 = this.myImage.getWidth();
        double d4 = this.myImage.getHeight();
        double d5 = Math.min(d / d3, 1.0);
        double d6 = Math.min(d2 / d4, 1.0);
        AffineTransform affineTransform = new AffineTransform();
        if (d5 < d6) {
            affineTransform.translate(insets.left, (double)insets.top + (d2 - d5 * d4) / 2.0);
            affineTransform.scale(d5, d5);
        } else if (d5 > d6) {
            affineTransform.translate((double)insets.left + (d - d6 * d3) / 2.0, insets.top);
            affineTransform.scale(d6, d6);
        } else {
            affineTransform.translate((double)insets.left + (d - d5 * d3) / 2.0, (double)insets.top + (d2 - d6 * d4) / 2.0);
            affineTransform.scale(d5, d6);
        }
        graphics2D.drawRenderedImage(this.myImage, affineTransform);
        graphics2D.dispose();
    }
}

