/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.replica;

import edu.rit.mp.BooleanBuf;
import edu.rit.mp.buf.BooleanItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.reduction.BooleanOp;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public class ReplicatedBoolean {
    private BooleanOp myOp;
    private AtomicBoolean myValue;
    private int myTag;
    private Comm myComm;
    private Receiver myReceiver;

    public ReplicatedBoolean(BooleanOp booleanOp) {
        this(booleanOp, false, 0, Comm.world());
    }

    public ReplicatedBoolean(BooleanOp booleanOp, boolean bl) {
        this(booleanOp, bl, 0, Comm.world());
    }

    public ReplicatedBoolean(BooleanOp booleanOp, boolean bl, int n) {
        this(booleanOp, bl, n, Comm.world());
    }

    public ReplicatedBoolean(BooleanOp booleanOp, boolean bl, int n, Comm comm) {
        if (booleanOp == null) {
            throw new NullPointerException("ReplicatedBoolean(): op is null");
        }
        if (comm == null) {
            throw new NullPointerException("ReplicatedBoolean(): comm is null");
        }
        this.myOp = booleanOp;
        this.myValue = new AtomicBoolean(bl);
        this.myTag = n;
        this.myComm = comm;
        this.myReceiver = new Receiver();
        this.myReceiver.setDaemon(true);
        this.myReceiver.start();
    }

    public boolean get() {
        return this.myValue.get();
    }

    public boolean reduce(boolean bl) throws IOException {
        boolean bl2;
        boolean bl3;
        while (!this.myValue.compareAndSet(bl3 = this.myValue.get(), bl2 = this.myOp.op(bl3, bl))) {
        }
        if (bl2 != bl3) {
            this.myComm.floodSend(this.myTag, BooleanBuf.buffer(bl2));
        }
        return bl2;
    }

    public String toString() {
        return Boolean.toString(this.get());
    }

    private class Receiver
    extends Thread {
        private Receiver() {
        }

        public void run() {
            BooleanItemBuf booleanItemBuf = BooleanBuf.buffer();
            try {
                while (true) {
                    boolean bl;
                    boolean bl2;
                    ReplicatedBoolean.this.myComm.floodReceive(ReplicatedBoolean.this.myTag, booleanItemBuf);
                    do {
                        bl2 = ReplicatedBoolean.this.myValue.get();
                        bl = ReplicatedBoolean.this.myOp.op(bl2, booleanItemBuf.item);
                    } while (!ReplicatedBoolean.this.myValue.compareAndSet(bl2, bl));
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
                return;
            }
        }
    }
}

