/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.CharacterOp;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class SharedCharacterArray {
    private AtomicIntegerArray myArray;

    public SharedCharacterArray(int n) {
        this.myArray = new AtomicIntegerArray(n);
    }

    public SharedCharacterArray(char[] cArray) {
        int n = cArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = cArray[i];
        }
        this.myArray = new AtomicIntegerArray(nArray);
    }

    public int length() {
        return this.myArray.length();
    }

    public char get(int n) {
        return (char)this.myArray.get(n);
    }

    public void set(int n, char c) {
        this.myArray.set(n, c);
    }

    public char getAndSet(int n, char c) {
        return (char)this.myArray.getAndSet(n, c);
    }

    public boolean compareAndSet(int n, char c, char c2) {
        return this.myArray.compareAndSet(n, c, c2);
    }

    public boolean weakCompareAndSet(int n, char c, char c2) {
        return this.myArray.weakCompareAndSet(n, c, c2);
    }

    public char getAndIncrement(int n) {
        char c;
        char c2;
        while (!this.myArray.compareAndSet(n, c2 = (char)this.myArray.get(n), c = (char)(c2 + '\u0001'))) {
        }
        return c2;
    }

    public char getAndDecrement(int n) {
        char c;
        char c2;
        while (!this.myArray.compareAndSet(n, c2 = (char)this.myArray.get(n), c = (char)(c2 - '\u0001'))) {
        }
        return c2;
    }

    public char getAndAdd(int n, char c) {
        char c2;
        char c3;
        while (!this.myArray.compareAndSet(n, c3 = (char)this.myArray.get(n), c2 = (char)(c3 + c))) {
        }
        return c3;
    }

    public char incrementAndGet(int n) {
        char c;
        char c2;
        while (!this.myArray.compareAndSet(n, c2 = (char)this.myArray.get(n), c = (char)(c2 + '\u0001'))) {
        }
        return c;
    }

    public char decrementAndGet(int n) {
        char c;
        char c2;
        while (!this.myArray.compareAndSet(n, c2 = (char)this.myArray.get(n), c = (char)(c2 - '\u0001'))) {
        }
        return c;
    }

    public char addAndGet(int n, char c) {
        char c2;
        char c3;
        while (!this.myArray.compareAndSet(n, c3 = (char)this.myArray.get(n), c2 = (char)(c3 + c))) {
        }
        return c2;
    }

    public char reduce(int n, char c, CharacterOp characterOp) {
        char c2;
        char c3;
        while (!this.myArray.compareAndSet(n, c3 = (char)this.myArray.get(n), c2 = characterOp.op(c3, c))) {
        }
        return c2;
    }

    public void reduce(char[] cArray, CharacterOp characterOp) {
        this.reduce(0, cArray, 0, this.myArray.length(), characterOp);
    }

    public void reduce(int n, char[] cArray, int n2, int n3, CharacterOp characterOp) {
        if (n3 < 0 || n < 0 || n + n3 > this.myArray.length() || n2 < 0 || n2 + n3 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        while (n3 > 0) {
            char c;
            char c2;
            while (!this.myArray.compareAndSet(n, c2 = (char)this.myArray.get(n), c = characterOp.op(c2, cArray[n2]))) {
            }
            ++n;
            ++n2;
            --n3;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n = this.myArray.length();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.get(i));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

