/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mri;

import edu.rit.mri.PixelTissues;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class TissuesDataSetWriter {
    private RandomAccessFile myFile;
    private int P;
    private int M;

    public TissuesDataSetWriter(File file, int n, int n2) throws IOException {
        if (file == null) {
            throw new NullPointerException("TissuesDataSetWriter(): theFile is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("TissuesDataSetWriter(): Height (= " + n + ") < 0, illegal");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("TissuesDataSetWriter(): Width (= " + n2 + ") < 0, illegal");
        }
        this.myFile = new RandomAccessFile(file, "rw");
        this.myFile.setLength(0L);
        this.myFile.writeInt(n);
        this.myFile.writeInt(n2);
        this.P = n * n2;
        for (int i = 0; i < this.P; ++i) {
            this.myFile.writeLong(0L);
        }
    }

    public void addPixelTissues(PixelTissues pixelTissues) throws IOException {
        if (pixelTissues == null) {
            throw new NullPointerException("TissuesDataSetWriter.addPixelTissues(): tissues is null");
        }
        int n = pixelTissues.pixelIndex();
        if (0 > n || n >= this.P) {
            throw new IndexOutOfBoundsException("TissuesDataSetWriter.addPixelTissues(): Pixel index (= " + n + ") out of bounds");
        }
        long l = this.myFile.length();
        this.myFile.seek(8L + (long)n * 8L);
        this.myFile.writeLong(l);
        this.myFile.seek(l);
        pixelTissues.write(this.myFile);
    }

    public void close() throws IOException {
        this.myFile.close();
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

