/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ShortBuf;
import edu.rit.mp.buf.ShortArrayBuf;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.pj.reduction.ShortOp;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

class ShortArrayReductionBuf
extends ShortArrayBuf {
    ShortOp myOp;

    public ShortArrayReductionBuf(short[] sArray, Range range, ShortOp shortOp) {
        super(sArray, range);
        if (shortOp == null) {
            throw new NullPointerException("ShortArrayReductionBuf(): op is null");
        }
        this.myOp = shortOp;
    }

    public void put(int n, short s) {
        int n2 = this.myArrayOffset + n * this.myStride;
        this.myArray[n2] = this.myOp.op(this.myArray[n2], s);
    }

    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof ShortArrayBuf) {
                ShortArrayBuf shortArrayBuf = (ShortArrayBuf)buf;
                ReduceArrays.reduce(shortArrayBuf.myArray, shortArrayBuf.myRange, this.myArray, this.myRange, this.myOp);
            } else {
                ShortBuf.defaultCopy((ShortBuf)buf, this);
            }
        }
    }

    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        int n3 = n;
        int n4 = this.myArrayOffset + n * this.myStride;
        int n5 = Math.min(n + n2, this.myLength);
        while (n3 < n5 && byteBuffer.remaining() >= 2) {
            this.myArray[n4] = this.myOp.op(this.myArray[n4], byteBuffer.getShort());
            ++n3;
            n4 += this.myStride;
        }
        return n3 - n;
    }
}

