/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.phyl;

import edu.rit.compbio.phyl.DnaSequenceList;
import edu.rit.compbio.phyl.DnaSequenceTree;
import edu.rit.compbio.phyl.FitchParsimony;
import edu.rit.compbio.phyl.JukesCantorDistance;
import edu.rit.compbio.phyl.MaximumParsimonyBnbSeq;
import edu.rit.compbio.phyl.MaximumParsimonyResults;
import edu.rit.compbio.phyl.Results;
import edu.rit.compbio.phyl.Upgma;
import edu.rit.pj.Comm;
import java.io.File;

public class PhylogenyParsBnbSeq {
    private PhylogenyParsBnbSeq() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        if (stringArray.length < 2 || stringArray.length > 4) {
            PhylogenyParsBnbSeq.usage();
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        int n = 100;
        if (stringArray.length >= 4) {
            n = Integer.parseInt(stringArray[3]);
        }
        DnaSequenceList dnaSequenceList = DnaSequenceList.read(file);
        int n2 = dnaSequenceList.length();
        if (stringArray.length >= 3) {
            n2 = Integer.parseInt(stringArray[2]);
        }
        dnaSequenceList.truncate(n2);
        DnaSequenceTree dnaSequenceTree = Upgma.buildTree(dnaSequenceList, new JukesCantorDistance());
        int n3 = FitchParsimony.computeScore(dnaSequenceTree);
        DnaSequenceList dnaSequenceList2 = dnaSequenceTree.toList();
        DnaSequenceList dnaSequenceList3 = new DnaSequenceList(dnaSequenceList2);
        int n4 = dnaSequenceList3.exciseUninformativeSites();
        long l2 = System.currentTimeMillis();
        MaximumParsimonyResults maximumParsimonyResults = new MaximumParsimonyResults(n);
        MaximumParsimonyBnbSeq maximumParsimonyBnbSeq = new MaximumParsimonyBnbSeq(dnaSequenceList3, n3 - n4, maximumParsimonyResults);
        maximumParsimonyBnbSeq.findTrees();
        maximumParsimonyResults.score(maximumParsimonyResults.score() + n4);
        long l3 = System.currentTimeMillis();
        Results.report(file2, "edu.rit.compbio.phyl.PhylogenyParsBnbSeq", Comm.world().host(), 1, file, dnaSequenceList, dnaSequenceList2, n3, n, maximumParsimonyResults, l, l2, l3);
        long l4 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec pre");
        System.out.println(l3 - l2 + " msec calc");
        System.out.println(l4 - l3 + " msec post");
        System.out.println(l4 - l + " msec total");
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.compbio.phyl.PhylogenyParsBnbSeq <infile> <outdir> [<N> [<T>]]");
        System.err.println("<infile> = Input DNA sequence list file name");
        System.err.println("<outdir> = Output directory name");
        System.err.println("<N> = Number of DNA sequences to use (default: all)");
        System.err.println("<T> = Number of trees to report (default: 100)");
        System.exit(1);
    }
}

