/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.antimatter;

import edu.rit.clu.antimatter.AntiprotonFile;
import edu.rit.pj.Comm;
import edu.rit.util.Random;
import edu.rit.vector.Vector2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;

public class AntiprotonSeq {
    static final double QP = 3.0;
    static final double B = 3.0;
    static final double QP_QP = 9.0;
    static final double QP_B = 9.0;
    static long seed;
    static double R;
    static double dt;
    static int steps;
    static int snaps;
    static int N;
    static File outfile;
    static double one_half_dt_sqr;
    static Vector2D[] a;
    static Vector2D[] v;
    static Vector2D[] p;
    static Vector2D totalMV;
    static Vector2D temp;

    private AntiprotonSeq() {
    }

    public static void main(String[] stringArray) throws Exception {
        Comm.init(stringArray);
        long l = System.currentTimeMillis();
        if (stringArray.length != 7) {
            AntiprotonSeq.usage();
        }
        seed = Long.parseLong(stringArray[0]);
        R = Double.parseDouble(stringArray[1]);
        dt = Double.parseDouble(stringArray[2]);
        steps = Integer.parseInt(stringArray[3]);
        snaps = Integer.parseInt(stringArray[4]);
        N = Integer.parseInt(stringArray[5]);
        outfile = new File(stringArray[6]);
        one_half_dt_sqr = 0.5 * dt * dt;
        Random random = Random.getInstance(seed);
        a = new Vector2D[N];
        v = new Vector2D[N];
        p = new Vector2D[N];
        for (int i = 0; i < N; ++i) {
            AntiprotonSeq.a[i] = new Vector2D();
            AntiprotonSeq.v[i] = new Vector2D();
            AntiprotonSeq.p[i] = new Vector2D(random.nextDouble() * R / 2.0 + R / 4.0, random.nextDouble() * R / 2.0 + R / 4.0);
        }
        AntiprotonFile antiprotonFile = new AntiprotonFile(seed, R, dt, steps, snaps + 1, N, 0, N);
        AntiprotonFile.Writer writer = antiprotonFile.prepareToWrite(new BufferedOutputStream(new FileOutputStream(outfile)));
        writer.writeSnapshot(p, 0, totalMV);
        long l2 = System.currentTimeMillis();
        for (int i = 0; i < snaps; ++i) {
            for (int j = 0; j < steps; ++j) {
                AntiprotonSeq.computeAcceleration();
                AntiprotonSeq.step();
            }
            AntiprotonSeq.computeTotalMomentum();
            writer.writeSnapshot(p, 0, totalMV);
        }
        writer.close();
        long l3 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec pre");
        System.out.println(l3 - l2 + " msec calc");
        System.out.println(l3 - l + " msec total");
    }

    private static void computeAcceleration() {
        for (int i = 0; i < N; ++i) {
            double d;
            int n;
            Vector2D vector2D = a[i];
            Vector2D vector2D2 = p[i];
            for (n = 0; n < i; ++n) {
                temp.assign(vector2D2);
                temp.sub(p[n]);
                d = temp.sqrMag();
                temp.mul(9.0 / (d * Math.sqrt(d)));
                vector2D.add(temp);
            }
            for (n = i + 1; n < N; ++n) {
                temp.assign(vector2D2);
                temp.sub(p[n]);
                d = temp.sqrMag();
                temp.mul(9.0 / (d * Math.sqrt(d)));
                vector2D.add(temp);
            }
        }
    }

    private static void step() {
        for (int i = 0; i < N; ++i) {
            Vector2D vector2D = a[i];
            Vector2D vector2D2 = v[i];
            Vector2D vector2D3 = p[i];
            temp.assign(vector2D2).mul(9.0).rotate270();
            vector2D.add(temp);
            temp.assign(vector2D2);
            vector2D3.add(temp.mul(dt));
            temp.assign(vector2D);
            vector2D3.add(temp.mul(one_half_dt_sqr));
            temp.assign(vector2D);
            vector2D2.add(temp.mul(dt));
            vector2D.clear();
        }
    }

    private static void computeTotalMomentum() {
        totalMV.clear();
        for (int i = 0; i < N; ++i) {
            totalMV.add(v[i]);
        }
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.clu.antimatter.AntiprotonSeq <seed> <R> <dt> <steps> <snaps> <N> <outfile>");
        System.err.println("<seed> = Random seed for initial antiproton positions");
        System.err.println("<R> = Side of square for initial antiproton positions");
        System.err.println("<dt> = Time step size");
        System.err.println("<steps> = Number of time steps between snapshots");
        System.err.println("<snaps> = Number of snapshots");
        System.err.println("<N> = Number of antiprotons");
        System.err.println("<outfile> = Output file name");
        System.exit(1);
    }

    static {
        totalMV = new Vector2D();
        temp = new Vector2D();
    }
}

