## ----dsetup,echo=FALSE,results="hide",include=FALSE---------------------------
suppressPackageStartupMessages({
library(BiocSklearn)
library(BiocStyle)
})

## ----loadup-------------------------------------------------------------------
library(BiocSklearn)
skels = SklearnEls()
skels

## ----doimp--------------------------------------------------------------------
irloc = system.file("csv/iris.csv", package="BiocSklearn")
irismat = skels$np$genfromtxt(irloc, delimiter=',')

## ----dota---------------------------------------------------------------------
skels$np$take(irismat, 0:2, 0L )

## ----dor----------------------------------------------------------------------
fullpc = prcomp(data.matrix(iris[,1:4]))$x

## ----dopc1--------------------------------------------------------------------
ppca = skPCA(irismat)
ppca

## ----lk1----------------------------------------------------------------------
tx = getTransformed(ppca)
dim(tx)
head(tx)

## ----dopy---------------------------------------------------------------------
pyobj(ppca)$fit_transform(irismat)[1:3,]

## ----lkconc-------------------------------------------------------------------
round(cor(tx, fullpc),3)

## ----doincr-------------------------------------------------------------------
ippca = skIncrPCA(irismat) #
ippcab = skIncrPCA(irismat, batch_size=25L)
round(cor(getTransformed(ippcab), fullpc),3)

## ----dopartial----------------------------------------------------------------
ta = skels$np$take # provide slicer utility
ipc = skPartialPCA_step(ta(irismat,0:49,0L))
ipc = skPartialPCA_step(ta(irismat,50:99,0L), obj=ipc)
ipc = skPartialPCA_step(ta(irismat,100:149,0L), obj=ipc)
ipc$transform(ta(irismat,0:5,0L))
fullpc[1:5,]

## ----lkmref-------------------------------------------------------------------
fn = system.file("ban_6_17/assays.h5", package="BiocSklearn")
ban = H5matref(fn)
ban 

## ----getmmm-------------------------------------------------------------------
np = import("numpy", convert=FALSE) # ensure
ban$shape

## ----dotx---------------------------------------------------------------------
ban2 = np$matrix(ban)$T

## ----dopart-------------------------------------------------------------------
st = skPartialPCA_step(ta(ban2, 0:999, 0L))
st = skPartialPCA_step(ta(ban2, 1000:10999, 0L), obj=st)
st = skPartialPCA_step(ta(ban2, 11000:44559, 0L), obj=st)
sss = st$transform(ban2)

## ----dover--------------------------------------------------------------------
iii = skPCA(ban2)
dim(getTransformed(iii))
round(cor(sss[,1:4], getTransformed(iii)[,1:4]),3)

