## ---- echo = FALSE, message = FALSE-------------------------------------------
library(sesame)
library(FlowSorted.Blood.450k)
ssets <- RGChannelSetToSigSets(FlowSorted.Blood.450k[,1:10])

## -----------------------------------------------------------------------------
sesameQC(ssets[[1]])

## -----------------------------------------------------------------------------
qc10 <- do.call(rbind, lapply(ssets, function(x)
    as.data.frame(sesameQC(x))))
qc10$sample_name <- names(ssets)

qc10[,c('mean_beta_cg','frac_meth_cg','frac_unmeth_cg','sex','age')]

## -----------------------------------------------------------------------------
library(ggplot2)
ggplot(qc10,
    aes(x = mean_oob_grn, y= mean_oob_red, label = sample_name)) +
    geom_point() + geom_text(hjust = -0.1, vjust = 0.1) +
    geom_abline(intercept = 0, slope = 1, linetype = 'dotted') +
    xlab('Green Background') + ylab('Red Background') +
    xlim(c(500,1200)) + ylim(c(500,1200))

## ----warning = FALSE----------------------------------------------------------
library(wheatmap)
p1 <- ggplot(qc10) +
    geom_bar(aes(sample_name, mean_intensity), stat='identity') +
    xlab('Sample Name') + ylab('Mean Intensity') +
    ylim(0,18000) +
    theme(axis.text.x = element_text(angle=90, vjust=0.5, hjust=1))
p2 <- ggplot(qc10) +
    geom_bar(aes(sample_name, mean_intensity_total), stat='identity') +
    xlab('Sample Name') + ylab('Mean M+U Intensity') +
    ylim(0,18000) +
    theme(axis.text.x = element_text(angle=90, vjust=0.5, hjust=1))
WGG(p1) + WGG(p2, RightOf())

## -----------------------------------------------------------------------------
ggplot(qc10) +
    geom_point(aes(InfI_switch_G2R, InfI_switch_R2G))

## -----------------------------------------------------------------------------
p1 <- ggplot(qc10) +
    geom_bar(aes(sample_name, num_na_cg), stat='identity') +
    xlab('Sample Name') + ylab('Number of NAs') +
    theme(axis.text.x = element_text(angle=90, vjust=0.5, hjust=1))
p2 <- ggplot(qc10) +
    geom_bar(aes(sample_name, frac_na_cg), stat='identity') +
    xlab('Sample Name') + ylab('Fraction of NAs (%)') +
    theme(axis.text.x = element_text(angle=90, vjust=0.5, hjust=1))
WGG(p1) + WGG(p2, RightOf())

