## ----scTensor with NCBI Gene ID, eval=FALSE-----------------------------------
#  library("scTensor")
#  library("LRBase.XXX.eg.db") # e.g. LRBase.Hsa.eg.db
#  # Input matrix
#  input <- ...
#  sce <- SingleCellExperiment(assays=list(counts = input))
#  # Color vector
#  color <- ...
#  # Celltype vector
#  label <- ...
#  cellCellSetting(sce, LRBase.XXX.eg.db, color, label)

## ----Seurat, eval=FALSE-------------------------------------------------------
#  library("Seurat")
#  
#  # Load the PBMC dataset
#  pbmc.data <- Read10X(data.dir = "filtered_gene_bc_matrices/hg19/")
#  
#  # Initialize the Seurat object with the raw (non-normalized data).
#  pbmc <- CreateSeuratObject(counts = pbmc.data,
#    project = "pbmc3k", min.cells = 3, min.features = 200)

## ----Ensembl with Organism DB, echo=TRUE--------------------------------------
suppressPackageStartupMessages(library("scTensor"))
suppressPackageStartupMessages(library("Homo.sapiens"))

# 1. Input matrix
input <- matrix(1:20, nrow=4, ncol=5)
# 2. Gene identifier in each row
rowID <- c("ENSG00000204531", "ENSG00000181449",
  "ENSG00000136997", "ENSG00000136826")
# 3. Corresponding table
LefttoRight <- select(Homo.sapiens,
  column=c("ENSEMBL", "ENTREZID"),
  keytype="ENSEMBL", keys=rowID)
# ID conversion
(input <- convertToNCBIGeneID(input, rowID, LefttoRight))

## ----Ensembl with AnnotationHub, echo=TRUE------------------------------------
suppressPackageStartupMessages(library("AnnotationHub"))

# 1. Input matrix
input <- matrix(1:20, nrow=4, ncol=5)
# 3. Corresponding table
ah <- AnnotationHub()
# Database of Human
hs <- query(ah, c("OrgDb", "Homo sapiens"))[[1]]
LefttoRight <- select(hs,
  column=c("ENSEMBL", "ENTREZID"),
  keytype="ENSEMBL", keys=rowID)
(input <- convertToNCBIGeneID(input, rowID, LefttoRight))

## ----Gene Symbol with Organism DB, echo=TRUE----------------------------------
# 1. Input matrix
input <- matrix(1:20, nrow=4, ncol=5)
# 2. Gene identifier in each row
rowID <- c("POU5F1", "SOX2", "MYC", "KLF4")
# 3. Corresponding table
LefttoRight <- select(Homo.sapiens,
  column=c("SYMBOL", "ENTREZID"),
  keytype="SYMBOL", keys=rowID)
# ID conversion
(input <- convertToNCBIGeneID(input, rowID, LefttoRight))

## ----Gene Symbol with AnnotationHub, echo=TRUE--------------------------------
# 1. Input matrix
input <- matrix(1:20, nrow=4, ncol=5)
# 3. Corresponding table
ah <- AnnotationHub()
# Database of Human
hs <- query(ah, c("OrgDb", "Homo sapiens"))[[1]]
LefttoRight <- select(hs,
  column=c("SYMBOL", "ENTREZID"),
  keytype="SYMBOL", keys=rowID)
(input <- convertToNCBIGeneID(input, rowID, LefttoRight))

## ----Seurat normalization, eval=FALSE-----------------------------------------
#  pbmc2 <- NormalizeData(pbmc, normalization.method = "LogNormalize",
#      scale.factor = 10000)
#  sce <- as.SingleCellExperiment(pbmc2)
#  assayNames(sce) # counts, logcounts

## ----Scater normalization, eval=FALSE-----------------------------------------
#  library("scater")
#  sce <- SingleCellExperiment(assays=list(counts = input))
#  cpm(sce) <- calculateCPM(sce)
#  sce <- normalize(sce)
#  assayNames(sce) # counts, normcounts, logcounts, cpm

## ----Original normalization, eval=FALSE---------------------------------------
#  # User's Original Normalization Function
#  CPMED <- function(input){
#      libsize <- colSums(input)
#      median(libsize) * t(t(input) / libsize)
#  }
#  # Normalization
#  normcounts(sce) <- log10(CPMED(counts(sce)) + 1)

## ----sessionInfo, echo=FALSE--------------------------------------------------
sessionInfo()

