/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences.gui;

import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.preferences.IdFilter;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class ImportSettingsDialog
extends JDialog {
    private boolean editable;
    private IdFilter userFilter = null;
    private IdFilter originalFilter;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JPanel filterPanel;
    private JButton helpJButton;
    private JTextField nAAmaxTxt;
    private JTextField nAAminTxt;
    private JButton okButton;
    private JLabel peptideLengthLabel;
    private JLabel peptideLengthRangeLabel;
    private JTextField precDevTxt;
    private JLabel precursorAccuracyLabel;
    private JCheckBox ptmsCheck;
    private JComboBox unitCmb;

    public ImportSettingsDialog(JFrame parent, IdFilter idFilter, boolean editable) {
        super((Frame)parent, true);
        this.editable = editable;
        this.originalFilter = idFilter;
        this.setUpGui();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public ImportSettingsDialog(JDialog parent, IdFilter idFilter, boolean editable) {
        super((Dialog)parent, true);
        this.editable = editable;
        this.originalFilter = idFilter;
        this.setUpGui();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void setUpGui() {
        double doubleValue;
        this.initComponents();
        this.unitCmb.setRenderer(new AlignedListCellRenderer(0));
        int intValue = this.originalFilter.getMinPepLength();
        if (intValue > 0) {
            this.nAAminTxt.setText(this.originalFilter.getMinPepLength() + "");
        }
        if ((intValue = this.originalFilter.getMaxPepLength()) > 0) {
            this.nAAmaxTxt.setText(this.originalFilter.getMaxPepLength() + "");
        }
        if ((doubleValue = this.originalFilter.getMaxMzDeviation()) > 0.0) {
            this.precDevTxt.setText(this.originalFilter.getMaxMzDeviation() + "");
        }
        this.ptmsCheck.setSelected(this.originalFilter.removeUnknownPTMs());
        if (this.originalFilter.isIsPpm()) {
            this.unitCmb.setSelectedIndex(0);
        } else {
            this.unitCmb.setSelectedIndex(1);
        }
        this.nAAminTxt.setEditable(this.editable);
        this.nAAmaxTxt.setEditable(this.editable);
        this.precDevTxt.setEditable(this.editable);
        this.unitCmb.setEnabled(this.editable);
        this.cancelButton.setEnabled(this.editable);
    }

    private boolean validateInput() {
        String input;
        try {
            input = this.nAAminTxt.getText();
            if (!input.equals("")) {
                new Integer(input);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Please verify the input for the minimal peptide length.", "Input Error", 0);
            return false;
        }
        try {
            input = this.nAAmaxTxt.getText();
            if (!input.equals("")) {
                new Integer(input);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Please verify the input for the maximal peptide length.", "Input Error", 0);
            return false;
        }
        try {
            input = this.precDevTxt.getText();
            if (!input.equals("")) {
                new Double(input);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Please verify the input for the precursor maximal deviation.", "Input Error", 0);
            return false;
        }
        return true;
    }

    public IdFilter getFilter() {
        return this.userFilter;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.filterPanel = new JPanel();
        this.nAAmaxTxt = new JTextField();
        this.peptideLengthRangeLabel = new JLabel();
        this.nAAminTxt = new JTextField();
        this.peptideLengthLabel = new JLabel();
        this.unitCmb = new JComboBox();
        this.precDevTxt = new JTextField();
        this.precursorAccuracyLabel = new JLabel();
        this.ptmsCheck = new JCheckBox();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.helpJButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Import Filters");
        this.setBackground(new Color(230, 230, 230));
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.filterPanel.setBorder(BorderFactory.createTitledBorder("Filters"));
        this.filterPanel.setOpaque(false);
        this.nAAmaxTxt.setHorizontalAlignment(0);
        this.peptideLengthRangeLabel.setHorizontalAlignment(0);
        this.peptideLengthRangeLabel.setText("-");
        this.nAAminTxt.setHorizontalAlignment(0);
        this.peptideLengthLabel.setText("Peptide Length");
        this.unitCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"ppm", "Da"}));
        this.precDevTxt.setHorizontalAlignment(0);
        this.precursorAccuracyLabel.setText("Precursor Accuracy");
        this.ptmsCheck.setText("Exclude Unknown PTMs");
        this.ptmsCheck.setHorizontalAlignment(2);
        this.ptmsCheck.setHorizontalTextPosition(10);
        this.ptmsCheck.setIconTextGap(10);
        this.ptmsCheck.setMargin(new Insets(2, 0, 2, 2));
        this.ptmsCheck.setOpaque(false);
        GroupLayout filterPanelLayout = new GroupLayout(this.filterPanel);
        this.filterPanel.setLayout(filterPanelLayout);
        filterPanelLayout.setHorizontalGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterPanelLayout.createSequentialGroup().addContainerGap().addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(filterPanelLayout.createSequentialGroup().addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.peptideLengthLabel).addComponent(this.precursorAccuracyLabel)).addGap(27, 27, 27).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.precDevTxt, -1, 67, Short.MAX_VALUE).addComponent(this.nAAminTxt)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peptideLengthRangeLabel, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nAAmaxTxt, -1, 74, Short.MAX_VALUE)).addGroup(filterPanelLayout.createSequentialGroup().addGap(205, 205, 205).addComponent(this.unitCmb, -2, 69, -2)).addComponent(this.ptmsCheck, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        filterPanelLayout.setVerticalGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterPanelLayout.createSequentialGroup().addContainerGap().addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nAAmaxTxt, -2, -1, -2).addComponent(this.nAAminTxt, -2, -1, -2).addComponent(this.peptideLengthLabel).addComponent(this.peptideLengthRangeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.unitCmb, -2, -1, -2).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.precDevTxt, -2, -1, -2).addComponent(this.precursorAccuracyLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ptmsCheck).addContainerGap(-1, Short.MAX_VALUE)));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportSettingsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ImportSettingsDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ImportSettingsDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportSettingsDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.helpJButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.filterPanel, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.filterPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.helpJButton, -1, -1, Short.MAX_VALUE).addComponent(this.okButton, -1, -1, Short.MAX_VALUE).addComponent(this.cancelButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.editable) {
            if (this.validateInput()) {
                boolean removePTM;
                boolean ppm;
                IdFilter tempFilter;
                int nAAmin = -1;
                String input = this.nAAminTxt.getText();
                if (!input.equals("")) {
                    nAAmin = new Integer(input);
                }
                int nAAmax = -1;
                input = this.nAAmaxTxt.getText();
                if (!input.equals("")) {
                    nAAmax = new Integer(input);
                }
                double precDev = -1.0;
                input = this.precDevTxt.getText();
                if (!input.equals("")) {
                    precDev = new Double(input);
                }
                if (!(tempFilter = new IdFilter(nAAmin, nAAmax, precDev, ppm = this.unitCmb.getSelectedIndex() == 0, removePTM = this.ptmsCheck.isSelected())).equals(this.originalFilter)) {
                    this.userFilter = tempFilter;
                }
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/FilterSettings.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), "Import Filters - Help", 500, 10);
        this.setCursor(new Cursor(0));
    }
}

