/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identifications.idfilereaders;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.PeptideAssumption;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.io.identifications.IdfileReader;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

public class AndromedaIdfileReader
extends ExperimentObject
implements IdfileReader {
    private HashMap<String, Long> index;
    private BufferedRandomAccessFile bufferedRandomAccessFile = null;
    private String fileName;

    public AndromedaIdfileReader() {
    }

    public AndromedaIdfileReader(File resFile) throws FileNotFoundException, IOException {
        this(resFile, null);
    }

    public AndromedaIdfileReader(File resFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        String line;
        this.bufferedRandomAccessFile = new BufferedRandomAccessFile(resFile, "r", 102400);
        this.fileName = Util.getFileName(resFile);
        if (waitingHandler != null) {
            waitingHandler.setMaxSecondaryProgressCounter(100);
        }
        long currentIndex = 0L;
        long progressUnit = this.bufferedRandomAccessFile.length() / 100L;
        this.index = new HashMap();
        String title = null;
        boolean newTitle = false;
        while ((line = this.bufferedRandomAccessFile.readLine()) != null) {
            if (line.startsWith(">")) {
                title = line.substring(1);
                newTitle = true;
                continue;
            }
            if (!newTitle) continue;
            currentIndex = this.bufferedRandomAccessFile.getFilePointer();
            this.index.put(title, currentIndex);
            newTitle = false;
            if (waitingHandler == null) continue;
            waitingHandler.setSecondaryProgressCounter((int)(currentIndex / progressUnit));
        }
    }

    @Override
    public String getExtension() {
        return ".res";
    }

    @Override
    public HashSet<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler) throws IOException, IllegalArgumentException, Exception {
        if (this.bufferedRandomAccessFile == null) {
            throw new IllegalStateException("The identification file was not set. Please use the appropriate constructor.");
        }
        HashSet<SpectrumMatch> result = new HashSet<SpectrumMatch>();
        for (String title : this.index.keySet()) {
            String line;
            SpectrumMatch currentMatch = new SpectrumMatch(Spectrum.getSpectrumKey(this.fileName, title));
            int cpt = 1;
            while ((line = this.bufferedRandomAccessFile.getNextLine()) != null && !line.startsWith(">")) {
                currentMatch.addHit(Advocate.andromeda.getIndex(), this.getAssumptionFromLine(line, cpt), true);
                ++cpt;
            }
            result.add(currentMatch);
        }
        return result;
    }

    private PeptideAssumption getAssumptionFromLine(String line, int rank) {
        String[] temp = line.trim().split("\t");
        String[] temp1 = temp[5].split(";");
        temp1 = temp[4].split(",");
        ArrayList<ModificationMatch> modMatches = new ArrayList<ModificationMatch>();
        for (int aa = 0; aa < temp1.length; ++aa) {
            String mod = temp1[aa];
            if (mod.equals("A")) continue;
            modMatches.add(new ModificationMatch(mod, true, aa));
        }
        Peptide peptide = new Peptide(temp[0], modMatches);
        Charge charge = new Charge(1, new Integer(temp[6]));
        double score = new Double(temp[1]);
        return new PeptideAssumption(peptide, rank, Advocate.andromeda.getIndex(), charge, score, this.fileName);
    }

    @Override
    public void close() throws IOException {
        this.bufferedRandomAccessFile.close();
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        ArrayList<String> versions = new ArrayList<String>();
        versions.add("1.4.0.0");
        result.put("Andromeda", versions);
        return result;
    }
}

