/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.util.gui;

import com.compomics.mascotdatfile.util.interfaces.FragmentIon;
import com.compomics.mascotdatfile.util.mascot.MascotDatfile;
import com.compomics.mascotdatfile.util.mascot.PeptideHit;
import com.compomics.mascotdatfile.util.mascot.Query;
import com.compomics.mascotdatfile.util.mascot.enumeration.MascotDatfileType;
import com.compomics.mascotdatfile.util.mascot.factory.MascotDatfileFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class SequenceFragmentationPanel
extends JPanel {
    private static Logger logger = Logger.getLogger(SequenceFragmentationPanel.class);
    private String[] iSequenceComponents;
    private Vector iFragmentIons;
    private double[] bIons;
    private double[] yIons;
    private Font iBaseFont = new Font("Monospaced", 0, 14);
    private final double iMaxBarHeight = 40.0;
    private final int iBarWidth = 3;
    private final int iHorizontalSpace = 3;
    private final int iXStart = 10;
    private boolean iBoolHighlightSequence = false;
    private boolean isModifiedSequence;

    public SequenceFragmentationPanel(String aModifiedSequence, Vector aFragmentIons) throws HeadlessException {
        this.isModifiedSequence = true;
        this.iSequenceComponents = this.parseSequenceIntoComponents(aModifiedSequence);
        this.iFragmentIons = aFragmentIons;
        this.normalizeMatchedIons();
        this.setMinimumSize(new Dimension(this.estimateWidth(), this.estimateHeight()));
    }

    public SequenceFragmentationPanel(String aSequence, Vector aFragmentIons, boolean boolModifiedSequence) throws HeadlessException {
        this.isModifiedSequence = boolModifiedSequence;
        this.iSequenceComponents = this.parseSequenceIntoComponents(aSequence);
        this.iFragmentIons = aFragmentIons;
        this.normalizeMatchedIons();
        this.setPreferredSize(new Dimension(this.estimateWidth(), this.estimateHeight()));
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(this.iBaseFont);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int yLocation = new Double(40.0).intValue() + 10;
        int xLocation = 10;
        int lFontHeight = g2.getFontMetrics().getHeight();
        Double lMidStringHeight = (double)yLocation - (double)lFontHeight * 0.2;
        for (int i = 0; i < this.iSequenceComponents.length; ++i) {
            g2.setColor(Color.black);
            int length = this.iSequenceComponents.length;
            if (this.iBoolHighlightSequence) {
                if (i == 0) {
                    if (this.bIons[i] != 0.0) {
                        g2.setColor(Color.black);
                        g2.drawLine(xLocation - 3, yLocation + 2, xLocation + g2.getFontMetrics().stringWidth(this.iSequenceComponents[i]) + 3, yLocation + 2);
                    }
                } else if (i == length - 1) {
                    if (this.yIons[this.yIons.length - i] != 0.0) {
                        g2.setColor(Color.red);
                    }
                } else {
                    if (this.bIons[i] != 0.0 && (this.bIons[i - 1] != 0.0 || this.bIons[i + 1] != 0.0)) {
                        g2.setColor(Color.black);
                        g2.drawLine(xLocation - 3, yLocation + 2, xLocation + g2.getFontMetrics().stringWidth(this.iSequenceComponents[i]) + 3, yLocation + 2);
                    }
                    if (this.yIons[this.yIons.length - i] != 0.0 && (this.yIons[this.yIons.length - (i + 1)] != 0.0 || this.yIons[this.yIons.length - (i - 1)] != 0.0)) {
                        g2.setColor(Color.red);
                    }
                }
            }
            g2.drawString(this.iSequenceComponents[i], xLocation, yLocation);
            xLocation = xLocation + g2.getFontMetrics().stringWidth(this.iSequenceComponents[i]) + 3;
            int lBarHeight = 0;
            if (i <= this.bIons.length - 1 && this.bIons[i] != 0.0) {
                lBarHeight = new Double(this.bIons[i] * 40.0).intValue();
                if (lBarHeight < 5) {
                    lBarHeight = 7;
                }
                g2.setColor(Color.BLUE);
                g2.fill(new Rectangle(xLocation, lMidStringHeight.intValue() + 1, 3, lBarHeight));
            }
            if (i <= this.yIons.length - 1 && this.yIons[this.yIons.length - (i + 1)] != 0.0) {
                lBarHeight = new Double(this.yIons[this.yIons.length - (i + 1)] * 40.0).intValue();
                if (lBarHeight < 5) {
                    lBarHeight = 7;
                }
                g2.setColor(Color.RED);
                int yBarStart = lMidStringHeight.intValue() - 1 - lBarHeight;
                g2.fill(new Rectangle(xLocation, yBarStart, 3, lBarHeight));
            }
            xLocation = xLocation + 3 + 3;
        }
        this.setPreferredSize(new Dimension(xLocation, 200));
    }

    private String[] parseSequenceIntoComponents(String aSequence) {
        String[] result;
        if (this.isModifiedSequence) {
            Vector<String> parts = new Vector<String>();
            String temp = aSequence;
            int start = 0;
            if (temp.startsWith("#")) {
                int nterm = temp.indexOf("#", start + 1);
                start = temp.indexOf("-", nterm);
            } else {
                start = temp.indexOf("-");
            }
            String part = temp.substring(0, ++start).trim();
            temp = temp.substring(start).trim();
            int endIndex = 1;
            if (temp.charAt(endIndex) == '<') {
                ++endIndex;
                while (temp.charAt(endIndex) != '>') {
                    ++endIndex;
                }
                ++endIndex;
            }
            part = part + temp.substring(0, endIndex);
            temp = temp.substring(endIndex);
            parts.add(part);
            while (temp.length() > 0) {
                start = 0;
                endIndex = 1;
                if (temp.charAt(start + endIndex) == '<') {
                    ++endIndex;
                    while (temp.charAt(start + endIndex) != '>') {
                        ++endIndex;
                    }
                    ++endIndex;
                }
                if (temp.charAt(start + endIndex) == '-') {
                    endIndex = temp.length();
                }
                part = temp.substring(0, endIndex);
                temp = temp.substring(endIndex);
                parts.add(part);
            }
            result = new String[parts.size()];
            parts.toArray(result);
        } else {
            result = new String[aSequence.length()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Character.toString(aSequence.charAt(i));
            }
        }
        return result;
    }

    private int estimateWidth() {
        int lEstimateX = 10;
        for (int i = 0; i < this.iSequenceComponents.length; ++i) {
            lEstimateX = lEstimateX + this.getFontMetrics(this.iBaseFont).stringWidth(this.iSequenceComponents[i]) + 3;
            lEstimateX = lEstimateX + 3 + 3;
        }
        return lEstimateX += 10;
    }

    private int estimateHeight() {
        int lEstimateY = 0;
        lEstimateY += 20;
        lEstimateY = (int)((double)lEstimateY + 72.0);
        return lEstimateY;
    }

    private void normalizeMatchedIons() {
        FragmentIon lFragmentIon;
        int i;
        int length = this.iSequenceComponents.length;
        this.bIons = new double[this.iSequenceComponents.length - 1];
        this.yIons = new double[this.iSequenceComponents.length - 1];
        double lMaxIntensity = 0.0;
        for (i = 0; i < this.iFragmentIons.size(); ++i) {
            lFragmentIon = (FragmentIon)this.iFragmentIons.elementAt(i);
            if (!(lMaxIntensity < lFragmentIon.getIntensity())) continue;
            lMaxIntensity = lFragmentIon.getIntensity();
        }
        block7: for (i = 0; i < this.iFragmentIons.size(); ++i) {
            lFragmentIon = (FragmentIon)this.iFragmentIons.elementAt(i);
            double lRatio = lFragmentIon.getIntensity() / lMaxIntensity;
            switch (lFragmentIon.getID()) {
                case 7: {
                    if (this.yIons[lFragmentIon.getNumber() - 1] != 0.0 && this.yIons[lFragmentIon.getNumber() - 1] > lRatio) {
                        lRatio = this.yIons[lFragmentIon.getNumber() - 1];
                    }
                    this.yIons[lFragmentIon.getNumber() - 1] = lRatio;
                    continue block7;
                }
                case 1: {
                    if (this.bIons[lFragmentIon.getNumber() - 1] != 0.0 && this.bIons[lFragmentIon.getNumber() - 1] > lRatio) {
                        lRatio = this.bIons[lFragmentIon.getNumber() - 1];
                    }
                    this.bIons[lFragmentIon.getNumber() - 1] = lRatio;
                    continue block7;
                }
                case 8: {
                    if (this.yIons[lFragmentIon.getNumber() - 1] != 0.0 && this.yIons[lFragmentIon.getNumber() - 1] > lRatio) {
                        lRatio = this.yIons[lFragmentIon.getNumber() - 1];
                    }
                    this.yIons[lFragmentIon.getNumber() - 1] = lRatio;
                    continue block7;
                }
                case 2: {
                    if (this.bIons[lFragmentIon.getNumber() - 1] != 0.0 && this.bIons[lFragmentIon.getNumber() - 1] > lRatio) {
                        lRatio = this.bIons[lFragmentIon.getNumber() - 1];
                    }
                    this.bIons[lFragmentIon.getNumber() - 1] = lRatio;
                }
            }
        }
    }

    public void setSequence(String lSequence, boolean boolModifiedSequence) {
        this.isModifiedSequence = boolModifiedSequence;
        this.iSequenceComponents = this.parseSequenceIntoComponents(lSequence);
    }

    public void setFragmentions(Vector lFragmentions) {
        this.iFragmentIons = lFragmentions;
        this.normalizeMatchedIons();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Sequence Fragmentation display.");
        frame.setDefaultCloseOperation(3);
        MascotDatfile lMascotDatfile = (MascotDatfile)MascotDatfileFactory.create(args[0], MascotDatfileType.MEMORY);
        int lPeptideHitNumber = Integer.parseInt(args[1]);
        PeptideHit lPeptideHit = lMascotDatfile.getQueryToPeptideMap().getPeptideHitOfOneQuery(lPeptideHitNumber);
        Vector lFragmentions = lPeptideHit.getPeptideHitAnnotation(lMascotDatfile.getMasses(), lMascotDatfile.getParametersSection()).getMatchedBYions(((Query)lMascotDatfile.getQueryList().get(lPeptideHitNumber - 1)).getPeakList());
        SequenceFragmentationPanel jpanImage = new SequenceFragmentationPanel(lPeptideHit.getModifiedSequence(), lFragmentions, false);
        jpanImage.setBorder(BorderFactory.createEtchedBorder());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                e.getWindow().dispose();
                System.exit(0);
            }
        });
        JPanel jpanMain = new JPanel();
        jpanMain.setLayout(new BorderLayout());
        jpanMain.add((Component)jpanImage, "Center");
        frame.getContentPane().add(jpanMain);
        frame.setLocation(100, 100);
        frame.setSize(jpanImage.getPreferredSize());
        frame.setVisible(true);
    }
}

