/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.writers;

import edu.msu.cme.rdp.readseq.QSequence;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.core.FastqCore;
import edu.msu.cme.rdp.readseq.writers.SequenceWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class FastqWriter
implements SequenceWriter {
    private PrintStream out;
    private FastqCore.QualityFunction qualFunction;
    private Byte defaultQuality;

    public FastqWriter(OutputStream is, FastqCore.QualityFunction qualFunction) {
        this(new PrintStream(is), qualFunction);
    }

    public FastqWriter(String s, FastqCore.QualityFunction qualFunction) throws IOException {
        this(new File(s), qualFunction);
    }

    public FastqWriter(File f, FastqCore.QualityFunction qualFunction) throws IOException {
        this(new PrintStream(f), qualFunction);
    }

    public FastqWriter(File f, FastqCore.QualityFunction qualFunction, byte defaultQual) throws IOException {
        this(new PrintStream(f), qualFunction, defaultQual);
    }

    public FastqWriter(PrintStream pw, FastqCore.QualityFunction qualFunction) {
        this.out = pw;
        this.qualFunction = qualFunction;
    }

    public FastqWriter(PrintStream pw, FastqCore.QualityFunction qualFunction, byte defaultQual) {
        this(pw, qualFunction);
        this.defaultQuality = defaultQual;
    }

    public void close() {
        this.out.close();
    }

    public void writeSeq(Sequence seq) throws IOException {
        if (seq.getClass() == QSequence.class) {
            QSequence s = (QSequence)seq;
            this.writeSeq(s.getSeqName(), s.getDesc(), s.getSeqString(), s.getQuality());
        } else if (this.defaultQuality != null) {
            byte[] qual = new byte[seq.getSeqString().length()];
            for (int index = 0; index < qual.length; ++index) {
                qual[index] = this.defaultQuality;
            }
            this.writeSeq(seq.getSeqName(), seq.getDesc(), seq.getSeqString(), qual);
        } else {
            throw new IOException("Fastq writer can only write QSequences");
        }
    }

    public void writeSeq(String seqid, String desc, String seqString, byte[] qualSeq) {
        this.out.println("@" + seqid + "  " + desc);
        this.out.println(seqString);
        this.out.println("+");
        StringBuffer qual = new StringBuffer();
        for (byte b : qualSeq) {
            qual.append(this.qualFunction.translate(b));
        }
        this.out.println(qual);
    }
}

