/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.xmlindex;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import psidev.psi.mi.xml.xmlindex.InputStreamRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsimiXmlFileIndex {
    private File file;
    private Map<Integer, InputStreamRange> experimentId2position = new HashMap<Integer, InputStreamRange>();
    private Map<Integer, InputStreamRange> interactorId2position = new HashMap<Integer, InputStreamRange>();
    private Map<Integer, InputStreamRange> interactionId2position = new HashMap<Integer, InputStreamRange>();
    private Map<Integer, InputStreamRange> participantId2position = new HashMap<Integer, InputStreamRange>();
    private Map<Integer, InputStreamRange> featureId2position = new HashMap<Integer, InputStreamRange>();

    public PsimiXmlFileIndex(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.file = file;
    }

    public Map<Integer, InputStreamRange> getExperimentId2position() {
        return Collections.unmodifiableMap(this.experimentId2position);
    }

    public void addExperiment(int experimentId, InputStreamRange position) {
        this.experimentId2position.put(experimentId, position);
    }

    public InputStreamRange getExperimentPosition(int experimentId) {
        return this.experimentId2position.get(experimentId);
    }

    public int getExperimentCount() {
        return this.experimentId2position.size();
    }

    public Map<Integer, InputStreamRange> getInteractorId2position() {
        return Collections.unmodifiableMap(this.interactorId2position);
    }

    public void addInteractor(int interactorId, InputStreamRange position) {
        this.interactorId2position.put(interactorId, position);
    }

    public InputStreamRange getInteractorPosition(int interactorId) {
        return this.interactorId2position.get(interactorId);
    }

    public int getInteractorCount() {
        return this.interactorId2position.size();
    }

    public Map<Integer, InputStreamRange> getInteractionId2position() {
        return Collections.unmodifiableMap(this.interactionId2position);
    }

    public void addInteraction(int interactionId, InputStreamRange position) {
        this.interactionId2position.put(interactionId, position);
    }

    public InputStreamRange getInteractionPosition(int interactionId) {
        return this.interactionId2position.get(interactionId);
    }

    public int getInteractionCount() {
        return this.interactionId2position.size();
    }

    public Map<Integer, InputStreamRange> getParticipantId2position() {
        return Collections.unmodifiableMap(this.participantId2position);
    }

    public void addParticipant(int participantId, InputStreamRange position) {
        this.participantId2position.put(participantId, position);
    }

    public InputStreamRange getParticipantPosition(int participantId) {
        return this.participantId2position.get(participantId);
    }

    public int getParticipantCount() {
        return this.participantId2position.size();
    }

    public Map<Integer, InputStreamRange> getFeatureId2position() {
        return Collections.unmodifiableMap(this.featureId2position);
    }

    public void addFeature(int featureId, InputStreamRange position) {
        this.featureId2position.put(featureId, position);
    }

    public InputStreamRange getFeaturePosition(int featureId) {
        return this.featureId2position.get(featureId);
    }

    public int getFeatureCount() {
        return this.featureId2position.size();
    }
}

