/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.converter.impl254;

import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.converter.impl254.AttributeConverter;
import psidev.psi.mi.xml.converter.impl254.CvTypeConverter;
import psidev.psi.mi.xml.converter.impl254.NamesConverter;
import psidev.psi.mi.xml.converter.impl254.OrganismConverter;
import psidev.psi.mi.xml.converter.impl254.RangeConverter;
import psidev.psi.mi.xml.converter.impl254.XrefConverter;
import psidev.psi.mi.xml.dao.DAOFactory;
import psidev.psi.mi.xml.dao.PsiDAO;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.ExperimentRef;
import psidev.psi.mi.xml.model.Feature;
import psidev.psi.mi.xml.model.FeatureDetectionMethod;
import psidev.psi.mi.xml.model.FeatureType;
import psidev.psi.mi.xml.model.Range;
import psidev.psi.mi.xml254.jaxb.AttributeList;
import psidev.psi.mi.xml254.jaxb.BaseLocation;
import psidev.psi.mi.xml254.jaxb.ExperimentRefList;
import psidev.psi.mi.xml254.jaxb.Feature;

public class FeatureConverter {
    private CvTypeConverter cvTypeConverter = new CvTypeConverter();
    private NamesConverter namesConverter = new NamesConverter();
    private XrefConverter xrefConverter = new XrefConverter();
    private OrganismConverter organismConverter = new OrganismConverter();
    private RangeConverter rangeConverter = new RangeConverter();
    private AttributeConverter attributeConverter = new AttributeConverter();
    private DAOFactory factory;

    public void setDAOFactory(DAOFactory factory) {
        this.factory = factory;
    }

    private void checkDependencies() throws ConverterException {
        if (this.factory == null) {
            throw new ConverterException("Please set a DAO factory in order to resolve experiment's id.");
        }
    }

    public Feature fromJaxb(psidev.psi.mi.xml254.jaxb.Feature jFeature) throws ConverterException {
        if (jFeature == null) {
            throw new IllegalArgumentException("You must give a non null JAXB Feature.");
        }
        this.checkDependencies();
        Feature mFeature = new Feature();
        mFeature.setId(jFeature.getId());
        if (jFeature.getNames() != null) {
            mFeature.setNames(this.namesConverter.fromJaxb(jFeature.getNames()));
        }
        if (jFeature.getXref() != null) {
            mFeature.setXref(this.xrefConverter.fromJaxb(jFeature.getXref()));
        }
        if (jFeature.getFeatureType() != null) {
            mFeature.setFeatureType(this.cvTypeConverter.fromJaxb(jFeature.getFeatureType(), FeatureType.class));
        }
        if (jFeature.getFeatureDetectionMethod() != null) {
            mFeature.setFeatureDetectionMethod(this.cvTypeConverter.fromJaxb(jFeature.getFeatureDetectionMethod(), FeatureDetectionMethod.class));
        }
        if (jFeature.getAttributeList() != null) {
            for (psidev.psi.mi.xml254.jaxb.Attribute jAttribute : jFeature.getAttributeList().getAttributes()) {
                mFeature.getAttributes().add(this.attributeConverter.fromJaxb(jAttribute));
            }
        }
        if (jFeature.getFeatureRangeList() != null) {
            for (BaseLocation jBaseLocation : jFeature.getFeatureRangeList().getFeatureRanges()) {
                mFeature.getRanges().add(this.rangeConverter.fromJaxb(jBaseLocation));
            }
        }
        if (jFeature.getExperimentRefList() != null) {
            PsiDAO<ExperimentDescription> experimentDAO = this.factory.getExperimentDAO();
            for (Integer experimentId : jFeature.getExperimentRefList().getExperimentReves()) {
                ExperimentDescription experimentDescription = experimentDAO.retreive(experimentId);
                if (experimentDescription == null) {
                    mFeature.getExperimentRefs().add(new ExperimentRef(experimentId));
                    continue;
                }
                mFeature.getExperiments().add(experimentDescription);
            }
        }
        PsiDAO<Feature> featureDAO = this.factory.getFeatureDAO();
        featureDAO.store(mFeature);
        return mFeature;
    }

    public psidev.psi.mi.xml254.jaxb.Feature toJaxb(Feature mFeature) throws ConverterException {
        if (mFeature == null) {
            throw new IllegalArgumentException("You must give a non null model Feature.");
        }
        this.checkDependencies();
        psidev.psi.mi.xml254.jaxb.Feature jFeature = new psidev.psi.mi.xml254.jaxb.Feature();
        jFeature.setId(mFeature.getId());
        if (mFeature.hasNames()) {
            jFeature.setNames(this.namesConverter.toJaxb(mFeature.getNames()));
        }
        if (mFeature.hasXref()) {
            jFeature.setXref(this.xrefConverter.toJaxb(mFeature.getXref()));
        }
        if (mFeature.hasFeatureType()) {
            jFeature.setFeatureType(this.cvTypeConverter.toJaxb(mFeature.getFeatureType()));
        }
        if (mFeature.hasFeatureDetectionMethod()) {
            jFeature.setFeatureDetectionMethod(this.cvTypeConverter.toJaxb(mFeature.getFeatureDetectionMethod()));
        }
        if (mFeature.getRanges() != null) {
            if (jFeature.getFeatureRangeList() == null) {
                jFeature.setFeatureRangeList(new Feature.FeatureRangeList());
            }
            for (Range range : mFeature.getRanges()) {
                jFeature.getFeatureRangeList().getFeatureRanges().add(this.rangeConverter.toJaxb(range));
            }
        }
        if (mFeature.hasExperiments()) {
            if (jFeature.getExperimentRefList() == null) {
                jFeature.setExperimentRefList(new ExperimentRefList());
            }
            for (ExperimentDescription experimentDescription : mFeature.getExperiments()) {
                jFeature.getExperimentRefList().getExperimentReves().add(experimentDescription.getId());
            }
        } else if (mFeature.hasExperimentRefs()) {
            if (jFeature.getExperimentRefList() == null) {
                jFeature.setExperimentRefList(new ExperimentRefList());
            }
            for (ExperimentRef experimentRef : mFeature.getExperimentRefs()) {
                jFeature.getExperimentRefList().getExperimentReves().add(experimentRef.getRef());
            }
        }
        if (mFeature.hasAttributes()) {
            if (jFeature.getAttributeList() == null) {
                jFeature.setAttributeList(new AttributeList());
            }
            for (Attribute attribute : mFeature.getAttributes()) {
                jFeature.getAttributeList().getAttributes().add(this.attributeConverter.toJaxb(attribute));
            }
        }
        return jFeature;
    }
}

