/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.tab2xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.converter.IdentifierGenerator;
import psidev.psi.mi.tab.converter.tab2xml.InteractorNameBuilder;
import psidev.psi.mi.tab.converter.tab2xml.XmlConversionException;
import psidev.psi.mi.tab.converter.xml2tab.InteractionConverter;
import psidev.psi.mi.tab.converter.xml2tab.InteractorConverter;
import psidev.psi.mi.tab.converter.xml2tab.MitabInteractionConverter;
import psidev.psi.mi.tab.converter.xml2tab.NullCrossReference;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.xml.PsimiXmlVersion;
import psidev.psi.mi.xml.converter.ConverterContext;
import psidev.psi.mi.xml.model.Alias;
import psidev.psi.mi.xml.model.DbReference;
import psidev.psi.mi.xml.model.Entry;
import psidev.psi.mi.xml.model.EntrySet;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Names;
import psidev.psi.mi.xml.model.Participant;
import psidev.psi.mi.xml.model.Source;
import psidev.psi.mi.xml.model.Xref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tab2Xml {
    public static final Log log = LogFactory.getLog(Tab2Xml.class);
    private InteractionConverter<?> interactionConverter;
    private InteractorNameBuilder interactorNameBuilder;
    protected static final String IREFINDEX = "irefindex";
    public static final String PSI_MI = "psi-mi";
    public static final String PSI_MI_REF = "MI:0488";
    public static final String IDENTITY = "identity";
    public static final String IDENTITY_REF = "MI:0356";
    public static final String UNKNOWN = "unknown";
    public static final String UNIPROT = "uniprotkb";
    private static final String UNIPROT_MI = "MI:0486";
    public static final String INTACT = "intact";
    private static final String INTACT_MI = "MI:0469";
    public static final String CHEBI = "chebi";
    private static final String CHEBI_MI = "MI:0474";

    public Tab2Xml() {
        this(new MitabInteractionConverter());
    }

    public Tab2Xml(InteractionConverter<?> interactionConverter) {
        this.interactionConverter = interactionConverter;
    }

    public EntrySet convert(Collection<BinaryInteraction> binaryInteractions) throws IllegalAccessException, XmlConversionException {
        if (binaryInteractions.isEmpty()) {
            throw new IllegalAccessException("No binary interactions found in the collection");
        }
        EntrySet entrySet = new EntrySet(PsimiXmlVersion.VERSION_25_UNDEFINED);
        HashMap<List<CrossReference>, Entry> listXrefEntryHashMap = new HashMap<List<CrossReference>, Entry>();
        HashMap interactionsPerSource = new HashMap();
        for (BinaryInteraction binaryInteraction : binaryInteractions) {
            Entry xmlEntry;
            List<CrossReference> sources = binaryInteraction.getSourceDatabases();
            if (!listXrefEntryHashMap.containsKey(sources)) {
                Source xmlSource = this.createSource(sources);
                xmlEntry = new Entry();
                xmlEntry.setSource(xmlSource);
                listXrefEntryHashMap.put(sources, xmlEntry);
                ArrayList<BinaryInteraction> lbi = new ArrayList<BinaryInteraction>();
                lbi.add(binaryInteraction);
                interactionsPerSource.put(xmlEntry, lbi);
                continue;
            }
            xmlEntry = (Entry)listXrefEntryHashMap.get(sources);
            ((List)interactionsPerSource.get(xmlEntry)).add(binaryInteraction);
        }
        for (Entry entry : interactionsPerSource.keySet()) {
            Collection binaryInteractionsPerSource = (Collection)interactionsPerSource.get(entry);
            Map<String, Collection<Participant>> interactionMap = this.createInteractionMap(binaryInteractionsPerSource);
            for (BinaryInteraction interaction2 : binaryInteractionsPerSource) {
                Collection<Interaction> interactions = this.interactionConverter.fromMitab(interaction2, interactionMap);
                entry.getInteractions().addAll(interactions);
            }
            entrySet.getEntries().add(entry);
        }
        return entrySet;
    }

    public InteractorNameBuilder getInteractorNameBuilder() {
        return this.interactorNameBuilder;
    }

    public void setInteractorNameBuilder(InteractorNameBuilder interactorNameBuilder) {
        this.interactorNameBuilder = interactorNameBuilder;
    }

    protected Map<String, Collection<Participant>> createInteractionMap(Collection<BinaryInteraction> miTabInteractions) throws IllegalAccessException, XmlConversionException {
        ArrayList<psidev.psi.mi.xml.model.Interactor> interactors = new ArrayList<psidev.psi.mi.xml.model.Interactor>();
        InteractorConverter<?> interactorConverter = this.interactionConverter.getInteractorConverter();
        HashMap<String, Collection<Participant>> interactionMap = new HashMap<String, Collection<Participant>>();
        interactorConverter.setInteractorNameBuilder(this.getInteractorNameBuilder());
        for (BinaryInteraction binaryInteraction : miTabInteractions) {
            psidev.psi.mi.xml.model.Interactor iA;
            List<CrossReference> crossReference = binaryInteraction.getInteractionAcs();
            if (crossReference.isEmpty()) {
                crossReference.add(new NullCrossReference(binaryInteraction));
            }
            StringBuilder interactionIdBuilder = new StringBuilder();
            interactionIdBuilder.append(crossReference.get(0).getIdentifier());
            interactionIdBuilder.append("_");
            Object A = binaryInteraction.getInteractorA();
            Object B = binaryInteraction.getInteractorB();
            Participant pA = null;
            Participant pB = null;
            if (A != null && B != null) {
                interactionIdBuilder.append(((Interactor)binaryInteraction.getInteractorA()).getIdentifiers().iterator().next().getIdentifier());
                interactionIdBuilder.append("_");
                interactionIdBuilder.append(((Interactor)binaryInteraction.getInteractorB()).getIdentifiers().iterator().next().getIdentifier());
                iA = interactorConverter.fromMitab((Interactor)binaryInteraction.getInteractorA());
                psidev.psi.mi.xml.model.Interactor iB = interactorConverter.fromMitab((Interactor)binaryInteraction.getInteractorB());
                iA = this.checkInteractor(iA, interactors);
                iB = this.checkInteractor(iB, interactors);
                pA = interactorConverter.buildParticipantA(iA, binaryInteraction, 0);
                pB = interactorConverter.buildParticipantB(iB, binaryInteraction, 0);
            } else if (A != null && !((Interactor)A).isEmpty()) {
                interactionIdBuilder.append(((Interactor)binaryInteraction.getInteractorA()).getIdentifiers().iterator().next().getIdentifier());
                iA = interactorConverter.fromMitab((Interactor)binaryInteraction.getInteractorA());
                iA = this.checkInteractor(iA, interactors);
                pA = interactorConverter.buildParticipantA(iA, binaryInteraction, 0);
            } else if (B != null && !((Interactor)B).isEmpty()) {
                interactionIdBuilder.append(((Interactor)binaryInteraction.getInteractorB()).getIdentifiers().iterator().next().getIdentifier());
                psidev.psi.mi.xml.model.Interactor iB = interactorConverter.fromMitab((Interactor)binaryInteraction.getInteractorB());
                iB = this.checkInteractor(iB, interactors);
                pB = interactorConverter.buildParticipantB(iB, binaryInteraction, 0);
            } else {
                new XmlConversionException("Both interactors are null or empty , we can not convert the interaction");
            }
            String interactionId = interactionIdBuilder.toString();
            Collection participants = null;
            participants = !interactionMap.containsKey(interactionId) ? new ArrayList() : (Collection)interactionMap.get(interactionId);
            if (pA != null && !participants.contains(pA)) {
                participants.add(pA);
            }
            if (pB != null && !participants.contains(pB)) {
                participants.add(pB);
            }
            interactionMap.put(interactionId, participants);
        }
        return interactionMap;
    }

    private psidev.psi.mi.xml.model.Interactor checkInteractor(psidev.psi.mi.xml.model.Interactor interactor1, List<psidev.psi.mi.xml.model.Interactor> interactors) {
        psidev.psi.mi.xml.model.Interactor auxInteractor = interactor1;
        for (psidev.psi.mi.xml.model.Interactor interactor2 : interactors) {
            if (!interactor1.equals(interactor2)) continue;
            auxInteractor = interactor2;
            break;
        }
        if (auxInteractor.equals(interactor1) && !interactors.contains(interactor1)) {
            interactors.add(auxInteractor);
        }
        return auxInteractor;
    }

    private Source createSource(Collection<CrossReference> sources) {
        Source source = new Source();
        Date date2 = new Date();
        source.setReleaseDate(date2);
        Names names = new Names();
        names.setShortLabel(UNKNOWN);
        source.setNames(names);
        if (sources != null) {
            Xref xref2 = new Xref();
            boolean found = false;
            for (CrossReference crossReference : sources) {
                DbReference dbRef;
                if (!found && crossReference.getDatabase().equalsIgnoreCase(PSI_MI)) {
                    String label = crossReference.getText();
                    if (label != null) {
                        names.setShortLabel(label);
                    }
                    dbRef = new DbReference();
                    dbRef.setDb(PSI_MI);
                    dbRef.setDbAc(PSI_MI_REF);
                    dbRef.setId(crossReference.getIdentifier());
                    dbRef.setRefType(IDENTITY);
                    dbRef.setRefTypeAc(IDENTITY_REF);
                    xref2.setPrimaryRef(dbRef);
                    found = true;
                    continue;
                }
                String database = crossReference.getDatabase();
                dbRef = new DbReference();
                dbRef.setId(crossReference.getIdentifier());
                dbRef.setDb(crossReference.getDatabase());
                if (database.equals(UNIPROT)) {
                    dbRef.setDbAc(UNIPROT_MI);
                    dbRef.setRefType(IDENTITY);
                    dbRef.setRefTypeAc(IDENTITY_REF);
                } else if (database.equals(CHEBI)) {
                    dbRef.setDbAc(CHEBI_MI);
                    dbRef.setRefType(IDENTITY);
                    dbRef.setRefTypeAc(IDENTITY_REF);
                } else if (database.equals(INTACT)) {
                    dbRef.setDbAc(INTACT_MI);
                    dbRef.setRefType(IDENTITY);
                    dbRef.setRefTypeAc(IDENTITY_REF);
                }
                xref2.getSecondaryRef().add(dbRef);
                if (!crossReference.hasText()) continue;
                Alias alias = new Alias(crossReference.getText());
                if (names.getAliases().isEmpty()) {
                    names.getAliases().add(alias);
                    continue;
                }
                if (names.getAliases().contains(alias)) continue;
                names.getAliases().add(alias);
            }
            if (found) {
                source.setNames(names);
                source.setXref(xref2);
            }
        }
        return source;
    }

    public void close() {
        IdentifierGenerator.remove();
        ConverterContext.remove();
    }
}

