/*
 * Decompiled with CFR 0.152.
 */
package org.sbgn;

import java.io.File;
import java.util.List;
import org.sbgn.ConvertMilestone1to2;
import org.sbgn.SbgnUtil;
import org.sbgn.schematron.Issue;
import org.sbgn.schematron.SchematronValidator;

public class Main {
    public static void main(String[] args) {
        Main main = new Main();
        try {
            main.run(args);
        }
        catch (IllegalArgumentException e2) {
            System.out.println("ERROR: " + e2.getMessage());
            main.printUsage();
            System.exit(1);
        }
    }

    private void printUsage() {
        System.out.println("Usage:\n\nsbgnutil -version\n    print versioh information.\n\nsbgnutil -help\n    print this help.\n\nsbgnutil -validate <file>:\n    Validate a single SBGN file.\n    First, low-level validation is performed on the XML syntax.\n    If the syntax is correct, the validator then proceeds with\n    high-level semantic validation.\n    Any validation issues found are printed as regular text.\n    Returns error code 2 if low-level validation failed,\n    or error code 3 if high-level validation failed.\n\nsbgnutil -upgrade <infile> <outfile>\n    Convert an sbgn file from Milestone 1 to Milestone 2.\n");
    }

    private void run(String[] args) {
        if (args.length == 0) {
            throw new IllegalArgumentException("Expected at least one argument");
        }
        String cmd = args[0];
        if ("-version".equals(cmd)) {
            if (args.length != 1) {
                throw new IllegalArgumentException("Did not expect any arguments after -version");
            }
            System.out.println("LibSBGN Milestone 2");
            return;
        }
        if ("-help".equals(cmd)) {
            if (args.length != 1) {
                throw new IllegalArgumentException("Did not expect any arguments after -help");
            }
            this.printUsage();
            return;
        }
        if ("-validate".equals(cmd)) {
            this.validate(args);
        } else if ("-upgrade".equals(cmd)) {
            this.upgrade(args);
        } else {
            throw new IllegalArgumentException("Unrecognized command: " + cmd);
        }
    }

    private void upgrade(String[] args) {
        if (args.length != 3) {
            throw new IllegalArgumentException("You have to specify an input file and an output file.");
        }
        File fin = new File(args[1]);
        File fout = new File(args[2]);
        try {
            ConvertMilestone1to2.convert(fin, fout);
        }
        catch (Exception e2) {
            System.err.println("Conversion failed because of " + e2.getClass().getName());
            System.err.println(e2.getMessage());
        }
    }

    private void validate(String[] args) {
        int pos = 1;
        if (args.length > pos && args[pos].equals("-svrldump")) {
            ++pos;
            SchematronValidator.setSvrlDump(true);
        }
        if (args.length == pos) {
            throw new IllegalArgumentException("Missing argument: input file");
        }
        File fin = new File(args[pos]);
        try {
            if (!SbgnUtil.isValid(fin)) {
                System.out.println("Low-level validation failed");
                System.exit(2);
            }
            System.out.println("Low-level validation passed");
            List<Issue> issues = SchematronValidator.validate(fin);
            System.out.println(issues.size() + " high-level validation issues");
            for (Issue i : issues) {
                System.out.println((Object)((Object)i.getSeverity()) + "\t" + i.getAboutId() + "\t" + i.getRuleId() + "\t" + i.getRuleDescription());
            }
            if (issues.size() > 0) {
                System.exit(3);
            }
            return;
        }
        catch (Exception e2) {
            System.err.println("Conversion failed because of " + e2.getClass().getName());
            System.err.println(e2.getMessage());
            return;
        }
    }
}

